C PRIMES
C   Prime number generator using the sieve of Eratosthenes
C   Converted to FORTRAN II
C
      DIMENSION IFLAGS(1000)
C     *** SET ENDING NUMBER TO BE TESTED (must match array dimension)
      ISIZE=1000
C     *** MARK ALL NUMBERS IN THE SIEVE AS PRIME INITIALLY, EXCEPT 2
      DO 10 I=1,ISIZE
10      IFLAGS(I)=1
      IFLAGS(1)=0
C
C     *** WORK THROUGH THE LIST, FINDING THE NEXT MARKED NUMBER
C
      DO 40 NUM=1,ISIZE
      IF (IFLAGS(NUM)) 15,40,15
C     *** MARKED NUMBER IS THE CURRENT PRIME, FORM ITS FIRST MULTIPLE
15    IPRIME=NUM
      MULT=IPRIME+IPRIME
C     *** UNMARK ALL MULTIPLES OF THE CURRENT PRIME
20    IF (MULT-ISIZE) 25,25,40
25    DO 30 I=MULT,ISIZE,IPRIME
30    IFLAGS(I)=0
C     *** GO FIND NEXT UNMARKED NUMBER
40    CONTINUE
C
C     *** PRINT RESULTS - ALL NUMBERS THAT ARE STILL MARKED
C
      WRITE OUTPUT TAPE 6,900
      DO 50 NUM=1,ISIZE
      IF (IFLAGS(NUM)) 45,50,45
45    WRITE OUTPUT TAPE 6,901,NUM
50    CONTINUE
      CALL EXIT
C
900   FORMAT(1H1,22H LIST OF PRIME NUMBERS)
901   FORMAT(1X,I5)
      END
