
;	 M     M   OOOOO    SSSSS	      CCCCC   TTTTTTT  L
;	 MM   MM  O	O  S	 S	     C	   C	 T     L
;	 M M M M  O	O  S		     C		 T     L
;	 M  M  M  O	O   SSSSS	     C		 T     L
;	 M     M  O	O	 S	     C		 T     L
;	 M     M  O	O  S	 S    ...    C	   C	 T     L
;	 M     M   OOOOO    SSSSS     ...     CCCCC	 T     LLLLLLL


;	THIS BATCH CONTROL FILE LISTS THE FILES ASSOCIATED WITH THE MF20 PDP-11
; SIDE DIAGNOSTIC SOFTWARE AND CONTAINS ALL THE NECESSARY STATEMENTS REQUIRED TO
; ASSEMBLE ANY PIECE OF THAT SOFTWARE.  THE FILE LIST IS SECOND HALF OF THIS
; FILE.  USE THE /TAG: SWITCH ON THE SUBMIT COMMAND TO PICK THE APPROPRIATE
; ASSEMBLY.  THE TAGS ARE DEFINED AS FOLLOWS:
;
;	[ BF-DHKBF       ]    X   X    [ N-NO LISTING      ]
;	[ BG-DHKBG       ]     X X     [ S-SHORT LISTING   ]
;	[ OV-DBGOVL      ]      X      [ M-MEDIUM LISTING  ]
;	[ MB-MEMORY BOOT ]     X X     [ L-LONG LISTING    ]
;			      X   X    [ R-RELEASE LISTING ]
;
; FOR INSTANCE "SUBMIT MOS/TAG:BFS" WOULD GET YOU AN ASSEMBLY OF DHKBF WITH A
; SHORT LISTING.  RELEASE ASSEMBLIES TAKE A LOT LONGER SO THEY SHOULD BE
; SUBMITTED WITH THE /TIME SWITCH.  SEE THE .INP FILES FOR LISTS OF FILES
; RELAVENT TO EACH DIAGNOSTIC RELEASE.
;
;	***** EXCEPTIONS *****
;
;	R20FN::  ASSEMBLE RSX20F MEM BOOT, NO GLOBALS.  MEDIUM LENGTH LISTING.
;	R20FG::  ASSEMBLE RSX20F MEM BOOT, WITH GLOBALS.  MEDIUM LENGTH LISTING.
;	DSMOSM:: ASSEMBLE THE MF20 DIAGNOSTIC SIGNAL NAME FILE.
;	SRI8::	ASSEMBLE MEM BOOT WHICH ALLOWS 8 MB20S, SHORT LISTING
;	SRI8R::	ASSEMBLE MEM BOOT WHICH ALLOWS 8 MB20S, RELEASE LISTING
;	DMPMEM:: ASSEMBLE THE KL10 MEMORY SYSTEM DUMPER PROGRAM.
;
;	MF20 TIMING FILES EACH HAVE THEIR OWN SPECIAL .CTL FILES CREATED BY THE
;	TECO PROGRAM MOSTIM.TEC.  SEE THE LAST PAGE OF THIS FILE FOR MORE INFO.


;      RRRR   EEEEE  M	 M  EEEEE  M   M  BBBB	 EEEEE	RRRR	 !!
;      R   R  E	     MM	MM  E	   MM MM  B   B	 E	R   R	 !!
;      RRRR   EEEE   M M M  EEEE   M M M  BBBB	 EEEE	RRRR	 !!
;      R  R   E	     M	 M  E	   M   M  B   B	 E	R  R
;      R   R  EEEEE  M	 M  EEEEE  M   M  BBBB	 EEEEE	R   R	 !!

; ***** WHEN GETTING READY FOR RELEASE, REMEMBER TO CHANGE ALL VERSION NUMBERS
; ***** CONTAINED IN THIS FILE, .P11 TITLE FILES, .HST FILES, .INP FILES, AND
; ***** .TXT FILES.  ALSO DON'T FORGET LAST COPYRIGHT DATES, RELEASE DATES, AND
; ***** 2-5-2 NUMBERS.  LONG LIVE THE BUREAUCRACY!


; ***** DROP THROUGH TO HERE IF /TAG SWITCH WAS FORGOTTEN.  PUNT. *****
@MAIL
*BARRY
*
*MOS BATCH ASSEMBLY FAILED BECAUSE YOU FORGOT /TAG:.  YOU TURKEY!

@LOGOUT

; ***** ASSEMBLE DHKBF (MF20 CONTROLLER DIAG, PART 1), NO LISTING *****

BFN::@R MACY11
*DHKBF,/DS:GBL=DSK:DHKBFT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBF,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@GOTO LOGOUT


; ***** ASSEMBLE DHKBF (MF20 CONTROLLER DIAG, PART 1), SHORT LISTING *****

BFS::@R MACY11
*DHKBF,DHKBF/DS:GBL/NL:SYM/NL:TOC=DSK:DHKBFT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBF,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@GOTO BFTECO



; ***** ASSEMBLE DHKBF (MF20 CONTROLLER DIAG, PART 1), MEDIUM LISTING *****

BFM::@R MACY11
*DHKBF,DHKBF/DS:GBL/NL:SYM/NL:TOC/EQ:LSTMB:LSBRTN=DSK:DHKBFT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBF,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@GOTO BFTECO



; ***** ASSEMBLE DHKBF (MF20 CONTROLLER DIAG, PART 1), LONG LISTING *****

BFL::@R MACY11
*DHKBF,DHKBF/DS:GBL/EQ:LSTALL:LSTDIA=DSK:DHKBFT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBF,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@GOTO BFTECO



; ***** HERE TO FINISH UP BY CLEANING UP PDP-10 WORDS IN LISTING. *****
BFTECO::@R TECO
*ERT.TECYHX0M0TENWD.TECDHKBF.LST
@IF(ERROR)@GOTO ERROR
@DELETE DHKBF.BAK
@IF(ERROR)
@GOTO LOGOUT

BFR::
; ***** BATCH CONTROL TO ASSEMBLE DHKBF FOR RELEASE. *****
;
;	ALL NECESSARY SOURCE FILES MUST ALREADY BE IN Z:<MOS-BARRY>.
;	COMMON CONVERSION PROGRAMS ARE IN Z:<CUSP10>
;
;-----POINT TO THE DIRECTORY WHICH HAS ALL THE FILES AND CALL IT DSK:.
@SMOUNT Z:
@IF (ERROR) @GOTO ERROR
@ACCESS Z:
@IF (ERROR) @GOTO ERROR
@DEFINE DSK: (AS) Z:<MOS-BARRY>
@IF (ERROR) @GOTO ERROR
@DEFINE LIB: (AS) Z:<CUSP10>
@IF (ERROR) @GOTO ERROR
@EXPUNGE DSK:
;-----TAKE A DIRECTORY OF ALL THE FILES NECESSARY FOR THE RELEASE.  NOTE THAT
; SOME OF THESE FILES ARE NOT USED DIRECTLY BY THIS PROCEDURE.
@ERROR %
@V DHKBF.INP,DHKBF.HLP,DSMOSM.A11,DBGOVL.A11,MOS.CTL,DHKBFT.P11
@IF (ERROR) @GOTO ERROR
@V PRM11.P11,MOSMAC.P11,MBMAC.P11,DIACON.P11,DHKBXC.P11,DHKBF.P11
@IF (ERROR) @GOTO ERROR
@V MBSUB.P11,MOSSUB.P11,STOR11.P11,T.TEC,TENWD.TEC,DHKBF.TXT
@IF (ERROR) @GOTO ERROR
@V MF20.FMT,DHKBF.HST,DBGOVT.P11,DBGOVL.P11,DBGOVL.HDR,DBGOVL.PNT
@IF (ERROR) @GOTO ERROR
@V DSMOSM.TXT,DSMOSM.SNO,DSMOST.P11,DSMOSM.P11,DSMOSM.HDR,DSMOSM.PNT
@IF (ERROR) @GOTO ERROR
@V MIRMAC.P11,DHKBFI.P11,MIRSUB.P11,H3.A11,H3.PNT
@IF (ERROR) @GOTO ERROR
;-----GET CHECKSUM OF EXISTING BIN FILE, IF ANY.
@VDIR DHKBF.BIN,
@CHECKSUM
@
@IF (ERROR)
;-----ASSEMBLE THE PROGRAM
@ERROR ?
@MACY11
*DHKBF,DHKBF/DS:GBL/EQ:RELEASE/CRF=DSK:DHKBFT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBF,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF (ERROR) @GOTO ERROR
;-----TAKE A DIRECTORY OF GENERATED FILES
@ERROR %
@VDIR DHKBF.LST
@IF (ERROR) @GOTO ERROR
@VDIR DHKBF.BIN,
@CHECKSUM
@
@IF (ERROR) @GOTO ERROR
;-----HERE TO CLEAN UP PDP-10 WORDS IN LISTING.
@ERROR ?
@R TECO
*ERT.TECYHX0M0TENWD.TECDHKBF.LST
@IF(ERROR) @GOTO ERROR
@DELETE DHKBF.BAK
@IF(ERROR)

; BFR:: CONTINUED
;-----GENERATE THE .DOC FILE AND COMBINE THE WHOLE MESS TO MAKE .SEQ
@ERROR ?
@RUN LIB:DECDOC
*DHKBF.LST/P/E/N
@IF (ERROR) @GOTO ERROR
@DELETE DHKBF.LST
@IF (ERROR)
@EXPUNGE DSK:
@RUN LIB:DECDOC
*DHKBF.CLF/E
@IF (ERROR) @GOTO ERROR
@RUN LIB:DECDOC
*DHKBF/S=DHKBF.TXT,MF20.FMT,DHKBF.HST,DHKBF.DOC,DHKBF.CLF,DBGOVL.HDR,DBGOVL.PNT,DSMOSM.HDR,DSMOSM.PNT
@IF (ERROR) @GOTO ERROR
@ERROR %
@VDIR DHKBF.SEQ
@IF (ERROR) @GOTO ERROR
@DELETE DHKBF.CLF,DHKBF.DOC
@IF (ERROR)
@EXPUNGE DSK:
@GOTO LOGOUT




;*******************************************************************************




; ***** ASSEMBLE DBGOVL (DIAGNOSTIC DEBUG OVERLAY), SHORT LISTING *****

OVS::@R MACY11
*DBGOVL,DBGOVL.PNT/DS:GBL/NL:TOC/NL:SYM=DSK:DBGOVT,LIB:PRM11,DSK:DBGOVL
@IF(ERROR)@GOTO ERROR
@GOTO COVERT

; ***** ASSEMBLE DBGOVL (DIAGNOSTIC DEBUG OVERLAY), MEDIUM LISTING *****

OVM::@R MACY11
*DBGOVL,DBGOVL.PNT/DS:GBL/NL:TOC=DSK:DBGOVT,LIB:PRM11,DSK:DBGOVL
@IF(ERROR)@GOTO ERROR
@GOTO COVERT

; ***** ASSEMBLE DBGOVL (DIAGNOSTIC DEBUG OVERLAY), LONG LISTING *****

OVL::@R MACY11
*DBGOVL,DBGOVL.PNT/DS:GBL/EQ:LSTALL=DSK:DBGOVT,LIB:PRM11,DSK:DBGOVL
@IF(ERROR)@GOTO ERROR
@GOTO COVERT

OVR::
; ***** BATCH CONTROL TO ASSEMBLE DBGOVL FOR RELEASE. *****
;
;	ALL NECESSARY SOURCE FILES MUST ALREADY BE IN Z:<MOS-BARRY>.
;	COMMON CONVERSION PROGRAMS ARE IN Z:<CUSP10>
;
;-----POINT TO THE DIRECTORY WHICH HAS ALL THE FILES AND CALL IT DSK:.
@SMOUNT Z:
@IF (ERROR) @GOTO ERROR
@ACCESS Z:
@IF (ERROR) @GOTO ERROR
@DEFINE DSK: (AS) Z:<MOS-BARRY>
@IF (ERROR) @GOTO ERROR
@DEFINE LIB: (AS) Z:<CUSP10>
@IF (ERROR) @GOTO ERROR
@EXPUNGE DSK:
;-----TAKE A DIRECTORY OF ALL NECESSARY FILES.
@ERROR %
@V DBGOVT.P11,PRM11.P11,DBGOVL.P11
@IF (ERROR) @GOTO ERROR
;-----ASSEMBLE THE PROGRAM
@ERROR ?
@MACY11
*DBGOVL,DBGOVL.PNT/DS:GBL/EQ:RELEASE/CRF=DSK:DBGOVT,LIB:PRM11,DSK:DBGOVL
@IF (ERROR) @GOTO ERROR
;-----TAKE A DIRECTORY OF GENERATED FILES
@ERROR %
@VDIR DBGOVL.BIN,DBGOVL.PNT
@IF (ERROR) @GOTO ERROR

;NOW CONVERT DBGOVL.BIN INTO DBGOVL.A11 AND GET RID OF THE .BIN FILE.
; ***** NOTE THE VERSION NUMBER BELOW *****
COVERT::@RUN LIB:CONVRT
*DBGOVL.BIN/E
*0.2    ;MOS DIAG DEBUG
@IF(ERROR)@GOTO ERROR
@VDIR DBGOVL
@DEL DBGOVL.BIN
@GOTO LOGOUT

; ***** BATCH CONTROL TO ASSEMBLE THE KL10 MEMORY SYSTEM STATUS DUMPER PROGRAM.
DMPMEM::
;MAKE SURE WE HAVE ALL THE NECESSARY FILES
@VDIR PRM11.P11,MOSMAC.P11,MBMAC.P11,DMPMEM.P11,MBSUB.P11,MOSSUB.P11
@IF(ERROR)@GOTO ERROR

;ASSEMBLE THE PROGRAM
@R MACY11
*DMPMEM,DMPMEM/DS:GBL=DSK:DMPMEM.P11
@IF(ERROR)@GOTO ERROR

;CLEAN UP THE LISTING
; ***** HERE TO FINISH UP BY CLEANING UP PDP-10 WORDS IN LISTING. *****
@R TECO
*ERT.TECYHX0M0TENWD.TECDMPMEM.LST
@IF(ERROR)@GOTO ERROR
@DEL DMPMEM.BAK
@IF(ERROR)

;NOW CONVERT DMPMEM.BIN INTO DMPMEM.A11 AND GET RID OF THE .BIN FILE.
; ***** NOTE THE VERSION NUMBER BELOW *****
@RUN LIB:CONVRT
*DMPMEM.BIN/E
*0.1	;KL10 MEM SYS STATUS DUMPER
@IF(ERROR)@GOTO ERROR
@DEL DMPMEM.BIN
@VDIR DMPMEM

@GOTO LOGOUT

; ***** ASSEMBLE DHKBG (MF20 CONTROLLER DIAG, PART 2), NO LISTING *****

BGN::@R MACY11
*DHKBG,/DS:GBL=DSK:DHKBGT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBG,DSK:MBSUB,DSK:MOSSUB,DSK:DHKBGX
@IF(ERROR)@GOTO ERROR
@GOTO LOGOUT



; ***** ASSEMBLE DHKBG (MF20 CONTROLLER DIAG, PART 2), SHORT LISTING *****

BGS::@R MACY11
*DHKBG,DHKBG/DS:GBL/NL:TOC/NL:SYM=DSK:DHKBGT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBG,DSK:MBSUB,DSK:MOSSUB,DSK:DHKBGX
@IF(ERROR)@GOTO ERROR
@GOTO BGTECO



; ***** ASSEMBLE DHKBG (MF20 CONTROLLER DIAG, PART 2), MEDIUM LISTING *****

BGM::@R MACY11
*DHKBG,DHKBG/DS:GBL/NL:TOC/NL:SYM/EQ:LSTMB:LSBRTN=DSK:DHKBGT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBG,DSK:MBSUB,DSK:MOSSUB,DSK:DHKBGX
@IF(ERROR)@GOTO ERROR
@GOTO BGTECO



; ***** ASSEMBLE DHKBG (MF20 CONTROLLER DIAG, PART 2), LONG LISTING *****

BGL::@R MACY11
*DHKBG,DHKBG/DS:GBL/EQ:LSTALL:LSTDIA=DSK:DHKBGT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBG,DSK:MBSUB,DSK:MOSSUB,DSK:DHKBGX
@IF(ERROR)@GOTO ERROR
@GOTO BGTECO



; ***** HERE TO FINISH UP BY CLEANING UP PDP-10 WORDS IN LISTING. *****
BGTECO::@R TECO
*ERT.TECYHX0M0TENWD.TECDHKBG.LST
@IF(ERROR)@GOTO ERROR
@DELETE DHKBG.BAK
@IF(ERROR)
@GOTO LOGOUT

BGR::
; ***** BATCH CONTROL TO ASSEMBLE DHKBG FOR RELEASE. *****
;
;	ALL NECESSARY SOURCE FILES MUST ALREADY BE IN Z:<MOS-BARRY>.
;	COMMON CONVERSION PROGRAMS ARE IN Z:<CUSP10>
;
;-----POINT TO THE DIRECTORY WHICH HAS ALL THE FILES AND CALL IT DSK:.
@SMOUNT Z:
@IF (ERROR) @GOTO ERROR
@ACCESS Z:
@IF (ERROR) @GOTO ERROR
@DEFINE DSK: (AS) Z:<MOS-BARRY>
@IF (ERROR) @GOTO ERROR
@DEFINE LIB: (AS) Z:<CUSP10>
@IF (ERROR) @GOTO ERROR
@EXPUNGE DSK:
;-----TAKE A DIRECTORY OF ALL THE FILES NECESSARY FOR THE RELEASE.  NOTE THAT
; SOME OF THESE FILES ARE NOT USED DIRECTLY BY THIS PROCEDURE.
@ERROR %
@V DHKBG.INP,DHKBG.HLP,MOS.CTL,DHKBGT.P11,PRM11.P11,MOSMAC.P11
@IF (ERROR) @GOTO ERROR
@V MBMAC.P11,DIACON.P11,DHKBXC.P11,DHKBG.P11,MBSUB.P11,MOSSUB.P11
@IF (ERROR) @GOTO ERROR
@V DHKBGX.P11,T.TEC,TENWD.TEC,DHKBG.TXT,MF20.FMT,DHKBG.HST
@IF (ERROR) @GOTO ERROR
@V MIRMAC.P11,DHKBGI.P11,MIRSUB.P11,I4.A11,I4.PNT
@IF (ERROR) @GOTO ERROR
;-----GET CHECKSUM OF EXISTING BIN FILE, IF ANY.
@VDIR DHKBG.BIN,
@CHECKSUM
@
@IF (ERROR)
;-----ASSEMBLE THE PROGRAM
@ERROR ?
@MACY11
*DHKBG,DHKBG/DS:GBL/EQ:RELEASE/CRF=DSK:DHKBGT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DIACON,DSK:DHKBXC,DSK:DHKBG,DSK:MBSUB,DSK:MOSSUB,DSK:DHKBGX
@IF (ERROR) @GOTO ERROR
;-----TAKE A DIRECTORY OF GENERATED FILES
@ERROR %
@VDIR DHKBG.LST
@IF (ERROR) @GOTO ERROR
@VDIR DHKBG.BIN,
@CHECKSUM
@
@IF (ERROR) @GOTO ERROR
;-----HERE TO CLEAN UP PDP-10 WORDS IN LISTING.
@ERROR ?
@R TECO
*ERT.TECYHX0M0TENWD.TECDHKBG.LST
@IF(ERROR) @GOTO ERROR
@DELETE DHKBG.BAK
@IF(ERROR)

; BGR:: CONTINUED
;-----GENERATE THE .DOC FILE AND COMBINE THE WHOLE MESS TO MAKE .SEQ
@ERROR ?
@RUN LIB:DECDOC
*DHKBG/P/E/N
@IF (ERROR) @GOTO ERROR
@DELETE DHKBG.LST
@IF (ERROR) @GOTO ERROR
@EXPUNGE DSK:
@RUN LIB:DECDOC
*DHKBG.CLF/E
@IF (ERROR) @GOTO ERROR
@RUN LIB:DECDOC
*DHKBG/S=DHKBG.TXT,MF20.FMT,DHKBG.HST,DHKBG.DOC,DHKBG.CLF
@IF (ERROR) @GOTO ERROR
@ERROR %
@VDIR DHKBG.SEQ
@IF (ERROR) @GOTO ERROR
@DELETE DHKBG.CLF,DHKBG.DOC
@IF (ERROR)
@EXPUNGE DSK:
@GOTO LOGOUT




;*******************************************************************************





DSMOSM::
;-----CONTROL CODE TO GENERATE THE DIAGNOSTIC SIGNAL NAME FILE (DSMOSM.A11) FOR
; THE MF20.  FIRST RUN SNOBOL TO CREATE MFSIGS.P11 FROM DSMOSM.TXT.
@SNOBOL
*DSMOSM
@IF(ERROR)@GOTO ERROR
;-----ASSEMBLE OVERLAY AND CONVERT .BIN TO .A11 FILE.
@MACY11
*DSMOSM,DSMOSM.PNT/DS:GBL/NL:TOC/NL:SYM=DSK:DSMOST,LIB:PRM11,DSK:DSMOSM,DSK:MFSIGS,LIB:STOR11
@IF(ERROR)@GOTO ERROR
;-----NOTE: VERSION NUMBER BELOW IS FOR DSMOSM WHICH WENT OUT WITH
; THE FIRST RELEASED VERSION OF DHKBF.
@LIB:CONVRT
*DSMOSM/E
*0.2 ;GREAT RENAME VERSION
@IF(ERROR)@GOTO ERROR
@DELETE DSMOSM.BIN,MFSIGS.P11
@IF(ERROR)
@GOTO LOGOUT

; ***** ASSEMBLE MEMCON (DIAGNOSTIC MEMORY CONFIGURATOR), NO LISTING *****

MBN::@R MACY11
*MEMCON,/DS:GBL=DSK:DGQFBT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DGQFB,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@GOTO MBCNVT

; ***** ASSEMBLE MEMCON (DIAGNOSTIC MEMORY CONFIGURATOR), SHORT LISTING *****

MBS::@R MACY11
*MEMCON,MEMCON/DS:GBL/NL:TOC/NL:SYM/EQ:LSTSW:LSTMB=DSK:DGQFBT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DGQFB,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@GOTO MBTECO

; ***** ASSEMBLE MEMCON, 8 MB20 VERSION, SHORT LISTING *****

SRI8::@R MACY11
*MEMCON,MEMCON/DS:GBL/NL:TOC/NL:SYM/EQ:LSTSW:LSTMB:SRI8MB=DSK:DGQFBT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DGQFB,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@R TECO
*ERT.TECYHX0M0TENWD.TECMEMCON.LST
@IF(ERROR)@GOTO ERROR
@DELETE MEMCON.BAK
@IF(ERROR)
@RUN LIB:CONVRT
*MEMCON/E
*0.0   UNSUPPORTED 8 MB20 VERSION
@IF(ERROR)@GOTO ERROR
@DELETE MEMCON.BIN
@IF(ERROR)
@GOTO LOGOUT

; ***** ASSEMBLE MEMCON (DIAGNOSTIC MEMORY CONFIGURATOR), MEDIUM LISTING *****

MBM::@R MACY11
*MEMCON,MEMCON/DS:GBL/NL:TOC/NL:SYM/EQ:LSTSW:LSTMB:LSBRTN=DSK:DGQFBT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DGQFB,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR
@GOTO MBTECO

; ***** ASSEMBLE MEMCON (DIAGNOSTIC MEMORY CONFIGURATOR), LONG LISTING *****

MBL::@R MACY11
*MEMCON,MEMCON/DS:GBL/EQ:LSTALL=DSK:DGQFBT,LIB:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DGQFB,DSK:MBSUB,DSK:MOSSUB,LIB:STOR11/LI
@IF(ERROR)@GOTO ERROR


; ***** HERE TO FINISH UP BY CLEANING UP PDP-10 WORDS IN LISTING. *****
MBTECO::@R TECO
*ERT.TECYHX0M0TENWD.TECMEMCON.LST
@IF(ERROR)@GOTO ERROR
@DELETE MEMCON.BAK
@IF(ERROR)
@GOTO MBCNVT

MBR::
; ***** BATCH CONTROL TO ASSEMBLE MEMCON (DGQFB) FOR RELEASE. *****
;
;	ALL NECESSARY SOURCE FILES MUST ALREADY BE IN Z:<MOS-BARRY>.
;	COMMON CONVERSION PROGRAMS ARE IN Z:<CUSP10>
;
;-----POINT TO THE DIRECTORY WHICH HAS ALL THE FILES AND CALL IT DSK:.
@SMOUNT Z:
@IF (ERROR) @GOTO ERROR
@ACCESS Z:
@IF (ERROR) @GOTO ERROR
@DEFINE DSK: (AS) Z:<MOS-BARRY>
@IF (ERROR) @GOTO ERROR
@DEFINE LIB: (AS) Z:<CUSP10>
@IF (ERROR) @GOTO ERROR
@EXPUNGE DSK:
;-----TAKE A DIRECTORY OF ALL THE FILES NECESSARY FOR THE RELEASE.  NOTE THAT
; SOME OF THESE FILES ARE NOT USED DIRECTLY BY THIS PROCEDURE.
@ERROR %
@V DGQFB.INP,MEMCON.HLP,BF16N1.A11,CONFG.CCL,CONFG1.CCL,CONFGR.CCL
@IF (ERROR) @GOTO ERROR
@V MOS.CTL,DGQFBT.P11,PRM11.P11,MOSMAC.P11,MBMAC.P11,DGQFB.P11
@IF (ERROR) @GOTO ERROR
@V MBSUB.P11,MOSSUB.P11,STOR11.P11,T.TEC,TENWD.TEC,DGQFB.TXT
@IF (ERROR) @GOTO ERROR
@V MF20.FMT,DGQFB.HST,MOSTIM.TEC,MOSTIM.P11,BF16N1.P11,BF16N1.HDR
@IF (ERROR) @GOTO ERROR
@V BF16N1.PNT,MBSUB.TEC,MBOVLC.P11,MOSDEF.MAC
@IF (ERROR) @GOTO ERROR
;-----ASSEMBLE THE PROGRAM
@ERROR ?
@MACY11
*MEMCON,DGQFB/DS:GBL/EQ:RELEASE/CRF=DSK:DGQFBT,DSK:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DGQFB,DSK:MBSUB,DSK:MOSSUB,DSK:STOR11
@IF (ERROR) @GOTO ERROR
;-----TAKE A DIRECTORY OF GENERATED FILES
@ERROR %
@VDIR DGQFB.LST
@IF (ERROR) @GOTO ERROR
@VDIR MEMCON.BIN,
@CHECKSUM
@
@IF (ERROR) @GOTO ERROR
;-----HERE TO CLEAN UP PDP-10 WORDS IN LISTING.
@ERROR ?
@R TECO
*ERT.TECYHX0M0TENWD.TECDGQFB.LST
@IF(ERROR)@GOTO ERROR
@DELETE DGQFB.BAK
@IF(ERROR)

; MBR:: CONTINUED
;-----GENERATE THE .DOC FILE AND COMBINE THE WHOLE MESS TO MAKE .SEQ
@ERROR ?
@RUN LIB:DECDOC
*DGQFB.LST/E
@IF (ERROR) @GOTO ERROR
@RUN LIB:DECDOC
*DGQFB/S=DGQFB.TXT,MF20.FMT,DGQFB.HST,DGQFB.DOC,DGQFB.LST,BF16N1.HDR,BF16N1.PNT,BF64N1.PNT
@IF (ERROR) @GOTO ERROR
@ERROR %
@VDIR DGQFB.SEQ
@IF (ERROR) @GOTO ERROR
@DELETE DGQFB.LST,DGQFB.DOC
@IF (ERROR)
@EXPUNGE DSK:
;-----FINALLY, CONVERT THE .BIN FILE TO .A11


; ***** ALSO GENERATE MEMCON.A11 AND DELETE THE .BIN FILE. *****
; ***** NOTE THE VERSION NUMBER BELOW *****
MBCNVT::@RUN LIB:CONVRT
*MEMCON/E
*0.7
@IF(ERROR)@GOTO ERROR
@DELETE MEMCON.BIN
@IF(ERROR)
@GOTO LOGOUT

; ***** ASSEMBLE FRONT-END MEMORY CONFIGURATOR, NO GLOBALS, MEDIUM LISTING *****

R20FN::@DELETE MBROOT.P11,CORDET.P11,MSSCTL.P11,DBEOVL.P11,FITCON.P11,
@EXP
@
@IF(ERROR)
@R TECO
*ERMBSUB.TECYHX0M0
@IF(ERROR)@GOTO ERROR
@R MACY11
*MBROOT,MBROOT/DS:GBL/NL:TOC:SYM/CRF/EQ:MBROOT:MBOKLG=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:MOSSUB,DSK:MBROOT
*CORDET,CORDET/DS:GBL/NL:TOC:SYM/CRF/EQ:CORDET:MBOKLG=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:CORDET
*MSSCTL,MSSCTL/DS:GBL/NL:TOC:SYM/CRF/EQ:MSSCTL:MBOKLG=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:MSSCTL
*DBEOVL,DBEOVL/DS:GBL/NL:TOC:SYM/CRF/EQ:DBEOVL:MBOKLG=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:DBEOVL
*FITCON,FITCON/DS:GBL/NL:TOC:SYM/CRF/EQ:FITCON:MBOKLG=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:FITCON
@IF(ERROR)@GOTO ERROR
@GOTO LOGOUT




; ***** ASSEMBLE FRONT-END MEMORY CONFIGURATOR WITH GLOBALS, MEDIUM LISTING ****

R20FG::@DELETE MBROOT.P11,CORDET.P11,MSSCTL.P11,DBEOVL.P11,FITCON.P11,
@EXP
@
@IF(ERROR)
@R TECO
*ERMBSUB.TECYHX0M0
@IF(ERROR)@GOTO ERROR
@R MACY11
*MBROOT,MBROOT/NL:TOC:SYM/CRF/EQ:MBROOT=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:MOSSUB,DSK:MBROOT
*CORDET,CORDET/NL:TOC:SYM/CRF/EQ:CORDET=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:CORDET
*MSSCTL,MSSCTL/NL:TOC:SYM/CRF/EQ:MSSCTL=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:MSSCTL
*DBEOVL,DBEOVL/NL:TOC:SYM/CRF/EQ:DBEOVL=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:DBEOVL
*FITCON,FITCON/NL:TOC:SYM/CRF/EQ:FITCON=DSK:MBOVLC,DSK:MOSMAC,DSK:MBMAC,DSK:MOSDEF.MAC,DSK:FITCON
@IF(ERROR)@GOTO ERROR
@GOTO LOGOUT

SRI8R::
; ***** BATCH CONTROL FOR MEMCON (DGQFB), UNSUPPORTED 8 MB20 VER, RELEASE. *****
;
;	ALL NECESSARY SOURCE FILES MUST ALREADY BE IN Z:<MOS-BARRY>.
;	COMMON CONVERSION PROGRAMS ARE IN Z:<CUSP10>
;
;-----POINT TO THE DIRECTORY WHICH HAS ALL THE FILES AND CALL IT DSK:.
@SMOUNT Z:
@IF (ERROR) @GOTO ERROR
@ACCESS Z:
@IF (ERROR) @GOTO ERROR
@DEFINE DSK: (AS) Z:<MOS-BARRY>
@IF (ERROR) @GOTO ERROR
@DEFINE LIB: (AS) Z:<CUSP10>
@IF (ERROR) @GOTO ERROR
@EXPUNGE DSK:
;-----TAKE A DIRECTORY OF ALL THE FILES NECESSARY FOR THE RELEASE.  NOTE THAT
; SOME OF THESE FILES ARE NOT USED DIRECTLY BY THIS PROCEDURE.
@ERROR %
@V DGQFB.INP,MEMCON.HLP,BF16N1.A11,CONFG.CCL,CONFG1.CCL,CONFGR.CCL
@IF (ERROR) @GOTO ERROR
@V MOS.CTL,DGQFBT.P11,PRM11.P11,MOSMAC.P11,MBMAC.P11,DGQFB.P11
@IF (ERROR) @GOTO ERROR
@V MBSUB.P11,MOSSUB.P11,STOR11.P11,T.TEC,TENWD.TEC,DGQFB.TXT
@IF (ERROR) @GOTO ERROR
@V MF20.FMT,DGQFB.HST,MOSTIM.TEC,MOSTIM.P11,BF16N1.P11,BF16N1.HDR
@IF (ERROR) @GOTO ERROR
@V BF16N1.PNT,MBSUB.TEC,MBOVLC.P11,MOSDEF.MAC
@IF (ERROR) @GOTO ERROR
;-----ASSEMBLE THE PROGRAM
@ERROR ?
@MACY11
*MEMCON,DGQFB/DS:GBL/EQ:RELEASE:SRI8MB/CRF=DSK:DGQFBT,DSK:PRM11,DSK:MOSMAC,DSK:MBMAC,DSK:DGQFB,DSK:MBSUB,DSK:MOSSUB,DSK:STOR11
@IF (ERROR) @GOTO ERROR
;-----TAKE A DIRECTORY OF GENERATED FILES
@ERROR %
@VDIR DGQFB.LST
@IF (ERROR) @GOTO ERROR
@VDIR MEMCON.BIN,
@CHECKSUM
@
@IF (ERROR) @GOTO ERROR
;-----HERE TO CLEAN UP PDP-10 WORDS IN LISTING.
@ERROR ?
@R TECO
*ERT.TECYHX0M0TENWD.TECDGQFB.LST
@IF(ERROR)@GOTO ERROR
@DELETE DGQFB.BAK
@IF(ERROR)

;-----GENERATE THE .DOC FILE AND COMBINE THE WHOLE MESS TO MAKE .SEQ
@ERROR ?
@RUN LIB:DECDOC
*DGQFB.LST/E
@IF (ERROR) @GOTO ERROR
@RUN LIB:DECDOC
*DGQFB/S=DGQFB.TXT,MF20.FMT,DGQFB.HST,DGQFB.DOC,DGQFB.LST,BF16N1.HDR,BF16N1.PNT
@IF (ERROR) @GOTO ERROR
@ERROR %
@VDIR DGQFB.SEQ
@IF (ERROR) @GOTO ERROR
@DELETE DGQFB.LST,DGQFB.DOC
@IF (ERROR)
@EXPUNGE DSK:
;-----FINALLY, CONVERT THE .BIN FILE TO .A11
MBCNVT::@RUN LIB:CONVRT
*MEMCON/E
*0.0   UNSUPPORTED 8 MB20 VERSION
@IF(ERROR)@GOTO ERROR
@DELETE MEMCON.BIN
@IF(ERROR)
@GOTO LOGOUT

; ***** COME HERE ON ANY SORT OF ERROR *****
ERROR::@MAIL
*BARRY
*
*MOS BATCH ASSEMBLY ERROR.  SEE MOS.LOG FOR DETAILS.

@LOGOUT



; ***** COME HERE UPON SUCCESSFULL COMPLETION OF ASSEMBLY & EVERYTHING. *****
LOGOUT::@MAIL
*BARRY
*
*MOS BATCH ASSEMBLY WAS SUCCESSFULL.

@LOGOUT

;      M   M  FFFFF   222    000	  FFFFF	 IIIII	L      EEEEE   SSSS
;      MM MM  F	     2	 2  0  00	  F	   I	L      E      S
;      M M M  FFFF     2    0 0	0	  FFFF	   I	L      EEEE    SSS
;      M   M  F	     2	    00	0	  F	   I	L      E	  S
;      M   M  F	     22222   000	  F	 IIIII	LLLLL  EEEEE  SSSS

;
;-----FILES AND PROGRAMS COMMON TO ALL MOS STUFF.
;

; MOS.CTL	THIS FILE.  CONTAINS CTL SEQUENCES FOR ALL MOS DIAGNOSTIC
;		SOFTWARE EXCEPT THE TIMING FILES.  SEE THE END OF MF20 FILES
;		DESCRIPTION FOR TIMING FILE GENERATION INFO.
; MOS.LOG	THE LOG FILE FOR THIS CTL FILE.  NOTE THAT ALL BATCH ASSEMBLY
;		ERROR/SUCCESS NOTIFICATION IS DONE THROUGH THE "MAIL" PROGRAM.
; MAIL.EXE	MAIL COMMUNICATIONS PROGRAM.
; TECO.EXE	FILE EDITOR.
; T.TEC		TECO MACRO CONTROL PROGRAM.
; TENWD.TEC	A TECO PROGRAM WHICH FIXES UP PDP-10 WORDS IN THE LISTINGS.
; CONVRT.EXE	A PROGRAM WHICH CHANGES FILES FROM .BIN TO .A11 FORMAT.
; DECDOC.EXE	A PROGRAM USED TO CREATE RELEASE LISTINGS.
; MAGTAP.EXE	USED TO CREATE RELEASE MAG TAPES.
; MACY11.EXE	PDP-11 ASSEMBLER WHICH RUNS ON A PDP-10.
; SNOBOL.EXE	SNOBOL INTERPRETER.
; MF20.FMT	GRAPHIC LAYOUT OF MF20 SBDIAG FUNCTIONS INCLUDED IN ALL
;		RELEASE LISTINGS.


;
;-----DHKBF & DHKBG FILES.  FIRST THE COMMON SOURCE FILES.
;

; PRM11.P11	THE STANDARD PARAM FILE FOR KL10 FRONT-END-RESIDENT DIAGNOSTICS.
; MOSMAC.P11	MOS SUBROUTINE CALLER MACRO SOURCE FILE.
; MBMAC.P11	MEMORY BOOT SUBROUTINE CALLER MACRO SOURCE FILE.
; DIACON.P11	STANDARD DIAGNOSTIC CONTROL PROGRAM SOURCE FILE.
; DHKBXC.P11	CODE COMMON TO BOTH DHKBF & DHKBG (ONETIME INIT, /CMD, ETC).
; MBSUB.P11	MEMORY BOOT SUBROUTINES SOURCE FILE.
; MOSSUB.P11	MOS SUBROUTINES SOURCE FILE.
; MIRMAC.P11	ISOLATION ROUTINE MACROS AND DEFINITIONS
; MIRSUB.P11	ISOLATION ROUTINE SUBROUTINES

; "SOURCE" FILES FOR DHKBF (MF20 CONTROLLER DIAGNOSTIC, PART 1).

; DHKBFT.P11	PROGRAM TITLE SOURCE FILE.
; DHKBF.P11	MAIN DIAGNOSTIC SOURCE FILE.
; STOR11.P11	STANDARD KL10 F-E-R DIAGNOSTIC TERMINATOR SOURCE FILE.
; DHKBFI.P11	SOURCE FILE FOR ALL OF DHKBF'S ISOLATION ROUTINES.

; DHKBF.HLP	RUN TIME HELP FILE FOR DHKBF.
; DHKBF.HST	HISTORY OF CHANGES TO DHKBF.
; DHKBF.TXT	FUNCTIONAL DESCRIPTION OF DHKBF.
; DHKBF.INP	MAGTAP PROGRAM CONTROL FILE FOR CREATING RELEASE TAPES.

; "CREATED" FILES FOR DHKBF.

; DHKBF.LST	LISTING FILE FOR NON-RELEASE ASSEMBLIES.  ALSO GENERATED FOR
;		RELEASE ASSEMBLIES BUT NORMALLY DELETED THEN.
; DHKBF.BIN	DIAGNOSTIC BINARY NOT SUITABLE FOR RELEASE.
; DHKBF.A11	GENERATED, ASCIIZED BINARY SUITABLE FOR RELEASE.
; DHKBF.SEQ	MASTER DIAGNOTIC LISTING FILE CREATED FOR RELEASE.
; DHKBF.BAK,DHKBF.CLF,DHKBF.DOC
;		THESE FILES MAY BE LEFT HANGING AROUND IF THERE IS AN ERROR IN
;		THE BATCH RELEASE PROCESS.

; H??.PNT	DHKBF ISOLATION ROUTINE LISTING.  NORMALLY INCLUDED AS PART OF
;		DHKBF.SEQ LISTING.
; H??.CTL	ISOLATION ROUTINE BATCH ASSEMBLY CONTROL FILE CREATED AND
;		SUBMITTED BY MOS.CTL.
; H??.A11	ASCIIZED BINARY OF DHKBF'S ISOLATION ROUTINES.
; H??.BIN	ISOLATION ROUTINE .BIN FILE.  MAY BE LEFT HANGING AROUND AFTER
;		A BATCH ASSEMBLY ERROR.  NORMALLY DELETED.
; H??.ERR	NULL FILE CREATED TO FLAG AN ISOLATION ROUTINE ASSEMBLY ERROR.

; "SOURCE" FILES FOR DHKBG (MF20 CONTROLLER DIAGNOSTIC, PART 2).

; DHKBGT.P11	PROGRAM TITLE SOURCE FILE.
; DHKBG.P11	MAIN DIAGNOSTIC SOURCE FILE.
; DHKBGX.P11	DHKBG OVERLAY-AREA EXTENSION SOURCE AND ASSEMBLY TERMINATOR.
; DHKBGI.P11	SOURCE FILE FOR ALL OF DHKBG'S ISOLATION ROUTINES.

; DHKBG.HLP	RUN TIME HELP FILE FOR DHKBG.
; DHKBG.HST	HISTORY OF CHANGES TO DHKBG.
; DHKBG.TXT	FUNCTIONAL DESCRIPTION OF DHKBG.
; DHKBG.INP	MAGTAP PROGRAM CONTROL FILE FOR CREATING RELEASE TAPES.

; "CREATED" FILES FOR DHKBG.

; DHKBG.LST	LISTING FILE FOR NON-RELEASE ASSEMBLIES.  ALSO GENERATED FOR
;		RELEASE ASSEMBLIES BUT NORMALLY DELETED THEN.
; DHKBG.BIN	DIAGNOSTIC BINARY NOT SUITABLE FOR RELEASE.
; DHKBG.A11	GENERATED, ASCIIZED BINARY SUITABLE FOR RELEASE.
; DHKBGX.A11	GENERATED, ASCIIZED BINARY FOR DIAG OVERLAY FOR RELEASE.
; DHKBG.SEQ	MASTER DIAGNOTIC LISTING FILE CREATED FOR RELEASE.
; DHKBG.BAK,DHKBG.CLF,DHKBG.DOC
;		THESE FILES MAY BE LEFT HANGING AROUND IF THERE IS AN ERROR IN
;		THE BATCH RELEASE PROCESS.

; I??.PNT	DHKBG ISOLATION ROUTINE LISTING.  NORMALLY INCLUDED AS PART OF
;		DHKBG.SEQ LISTING.
; I??.CTL	ISOLATION ROUTINE BATCH ASSEMBLY CONTROL FILE CREATED AND
;		SUBMITTED BY MOS.CTL.
; I??.A11	ASCIIZED BINARY OF DHKBG'S ISOLATION ROUTINES.
; I??.BIN	ISOLATION ROUTINE .BIN FILE.  MAY BE LEFT HANGING AROUND AFTER
;		A BATCH ASSEMBLY ERROR.  NORMALLY DELETED.
; I??.ERR	NULL FILE CREATED TO FLAG AN ISOLATION ROUTINE ASSEMBLY ERROR.

;
;-----DIAGNOSTIC MEMORY BOOT (MEMCON/DGQFB).  "SOURCE" FILES FIRST.
;

; DGQFBT.P11	DIAGNOTIC MEMORY BOOT TITLE SOURCE FILE.
; PRM11.P11	THE STANDARD PARAM FILE FOR KL10 FRONT-END-RESIDENT DIAGNOSTICS.
; MOSMAC.P11	MOS SUBROUTINE CALLER MACRO SOURCE FILE.
; MBMAC.P11	MEMORY BOOT SUBROUTINE CALLER MACRO SOURCE FILE.
; DGQFB.P11	DIGNOSTIC MEM BOOT MAIN PROGRAM AND COMMAND HANDLER SOURCE FILE.
; MBSUB.P11	MEMORY BOOT SUBROUTINES SOURCE FILE.
; MOSSUB.P11	MOS SUBROUTINES SOURCE FILE.
; STOR11.P11	STANDARD F-E-R PROGRAM TERMINATOR SOURCE FILE.

; MEMCON.HLP	RUN TIME HELP FILE FOR MEMCON.
; DGQFB.TXT	FUNCTIONAL DESCRIPTION OF MEMCON.
; DGQFB.HST	HISTORY OF CHANGES TO MEMCON.
; DGQFB.INP	MAGTAP PROGRAM CONTROL FILE FOR CREATING RELEASE TAPES.

; GENERATED MEMORY BOOT FILES.

; MEMCON.LST	NON-RELEASE LISTING OF MEMCON.
; DGQFB.SEQ	RELEASE LISTING OF MEMCON
; MEMCON.A11	ASCIIZED BINARY OF MEMCON.
; MEMCON.BIN,MEMCON.BAK,DGQFB.LST,DGQFB.BAK,DGQFB.CLF
;		THESE FILES MAY BE LEFT HANGING AROUND AFTER A MOS BATCH ERROR.


;
;-----FRONT END MEMORY BOOT SOURCE FILES.
;

; MOSDEF.MAC	THIS FILE IS CREATED AND MAINTAINED BY THE FRONT-END GROUP.
;		IT CONTAINS COMPATABILITY MACROS WHICH TRANSLATE THE DIAGNOSTIC
;		ENVIRONMENT EMTS INTO THE PROPER RSX-20F CALLS.  THIS FILE IS
;		USED IN THE DIAGNOSTIC ENVIRONMENT ONLY TO VERIFY A CLEAN
;		ASSEMBLY FOR THE FRONT-END ENVIRONEMENT.
; MBOVLC.P11	MEMORY BOOT OVERLAY CONTROL PARAMETER FILE.
; MBSUB.TEC	A TECO PROGRAM WHICH TAKES THE DIAGNOSTIC MEMORY BOOT SOURCE
;		FILE, "MBSUB.P11", AND BREAKS IT UP INTO PIECES AS REQUIRED FOR
;		ASSEMBLING THE FRONT-END MEMORY BOOT.
; MBROOT.P11, CORDET.P11, MSSCTL.P11, DBEOVL.P11, AND FITCON.P11.
; MBROOT.LST, CORDET.LST, MSSCTL.LST, DBEOVL.LST, AND FITCON.LST.
; MBROOT.OBJ, CORDET.OBJ, MSSCTL.OBJ, DBEOVL.OBJ, AND FITCON.OBJ.
;		THE ABOVE FILES ARE CREATED BY MBSUB.TEC, WHICH BREAKS UP
;		THE DIAGNOSTIC MEMORY BOOT SOURCE FILE TO CREATE THESE
;		INDIVIDUAL OVERLAY MODULE SOURCE FILES.  THESE ARE LEFT HANGING
;		AROUND AFTER THE ASSEMBLY IS DONE, AND ARE OF NO PARTICULAR USE
;		TO US.  HOWEVER THE 5 .P11 FILES MUST BE SHIPPED OFF TO THE
;		FRONT-END PEOPLE.
; MBMAC.P11, MBSUB.P11, MOSMAC.P11, AND MOSSUB.P11
;		THESE FILES ARE ALSO REQUIRED FOR ASSEMBLING THE FRONT-END
;		MEMORY BOOT.


;
;-----DIAGNOSTIC DEBUGGER OVERLAY.  "SOURCE" FILES FIRST.
;

; DBGOVT.P11	OVERLAY TITLE SOURCE FILE.
; PRM11.P11	THE STANDARD PARAM FILE FOR KL10 FRONT-END-RESIDENT DIAGNOSTICS.
; DBGOVL.P11	THE MAIN CODE BODY AND ASSEMBLY TERMINATOR.
; DBGOVL.HDR	HEADER FILE FOR DBGOVL.PNT IN DHKBF.SEQ.

; CREATED FILE FOR DBGOVL.

; DBGOVL.A11	ASCIIZED BINARY FILE.
; DBGOVL.BIN	BINARY FILE FOR DBGOVL WHICH MAY BE LEFT HANGING AROUND AFTER
;		A BATCH ASSEMBLY ERROR.
; DBGOVL.PNT	LISTING FILE FOR DBGOVL.  ULTIMATELY GOES INTO DHKBF.SEQ.


;
;-----MF20 DIAGNOSTIC SIGNAL NAME FILE.  "SOURCE" FILES.
;

; DSMOSM.TXT	THE ULTIMATE SOURCE FOR MF20 DIAGNOSTIC SIGNAL NAMES.  THIS FILE
;		WAS ORIGINALLY CREATED BY A LOT OF MANUAL AND AUTOMATIC WORK
;		ON THE PROTOTYPE MF20 WIRELIST FILES.  I SUGGEST THAT ANY
;		UPDATES NEEDED BE DONE BY HAND.
; DSMOSM.SNO	A SNOBOL PROGRAM WHICH CONVERTS DSMOSM.TXT INTO MFSIGS.P11.
; DSMOST.P11	THE ASSEMBLY TITLE SOURCE FILE.
; PRM11.P11	THE STANDARD PARAM FILE FOR KL10 FRONT-END-RESIDENT DIAGNOSTICS.
; DSMOSM.P11	THE SOURCE FOR THE CODE TO HANDLE THE DIAG SIGNAL NAME DATA.
; STOR11.P11	STANDARD KL10 F-E-R DIAGNOSTIC TERMINATOR SOURCE FILE.
; DSMOSM.HDR	HEADER FILE FOR DSMOSM.PNT IN DHKBF.SEQ.

; MFSIGS.P11	THE AUTOMATICALLY CREATED SOURCE FOR DSMOSM.  NORMALLY DELETED.
; DSMOSM.PNT	THE LISTING FILE FOR DSMOSM.A11.  THIS IS INCLUDED IN BOTH
;		DHKBF.SEQ AND DHKBG.SEQ, BUT IS ALSO MAINTAINED SEPARATELY.
; DSMOSM.BIN	INTERMEDIATE BINARY FILE.  NORMALLY DELETED.
; DSMOSM.A11	THE MF20 DIAGNOSTIC SIGNAL NAME FILE.

;-----MOS TIMING FILES.  CURRENTLY THERE IS ONLY ONE OF THESE DEFINED (BF16N1).
; REMEMBER THAT IT IS ENGINEERING'S RESPONSIBILITY TO COME UP WITH NEW TIMINGS
; AS THEY ARE NEEDED, AND ALSO TO DO THE RELEASE PAPERWORK.  THE COMMON FILES
; ARE LISTED FIRST.

; MOSTIM.TEC	A TECO PROGRAM USED TO GENERATE INDIVIDUAL CTL FILES FOR EACH
;		DIFFERENT TIMING.  TO RUN IT TYPE:
;		@R TECO
;		*ERMOSTIM.TEC$YHX0M0$$
;		-- AND IT WILL PROMPT YOU FROM THAT POINT ON.  THE CTL FILE
;		CREATED PAYS NO ATTENTION TO FILE STRUCTURES OR DIRECTORIES.
;		THEREFORE YOUR FILE BATCH.CMD MUST SET UP THINGS PROPERLY.
; MOSTIM.P11	THE TIMING DATA MACRO AND ASSEMBLY CONTROL SOURCE.

; FILES FOR THE BF16N1 (KL10 MODEL B, 16K RAM TIMING NUMBER 1) TIMING.

; BF16N1.P11	TIMING DATA SOURCE AND .END STATEMENT.  THIS COMES FROM LCEG.
; BF16N1.HDR	HEADER FILE FOR BF16N1.PNT IN DGQFB.SEQ.
; BF16N1.CTL	CTL FILE CREATED BY MOSTIM.TEC FOR THIS TIMING.
; BF16N1.A11	THE RESULTING TIMING FILE.
; BF16N1.LOG	LOG FILE FOR BF16N1.CTL.
; BF16N1.PNT	BF16N1 TIMING ASSEMBLY LISTING.
; BF16N1.ERR	NULL FILE CREATED ON SOME ERROR.
; BF16N1.BIN	MAY BE LEFT HANGING AROUND AFTER AN ERROR.

   