C	TATTLE V.2 - PROGRAM TO ANALYZE OUTPUT OF SNOOPY
C
C	READS A FILE PRODUCED BY SNOOPY
C	AND PRODUCES A LISTING OF TIMING BREAKDOWNS.
C
	INTEGER HEADLN, CONFIG(7), TODAY, NOW, USERF, INTRVL, INTLVL
	INTEGER COMENT(10), MONDAT(12), LOSDAT(12), HISDAT(12)
	INTEGER JOBNO, WCHAN, CYCLE, CPUN, EXTKLM, BUGS, TOTAL
	INTEGER PITAB(7), HISTOG(1)

	INTEGER MONFSP(9), MONRES, MONLIM, MONMAX
	INTEGER LOSFSP(9), LOSRES, LOSLIM, LOSMAX
	INTEGER HISFSP(9), HISRES, HISLIM, HISMAX

	INTEGER LOSTAB, HISTAB, MONTAB, UUOTAB, OPCTAB, QUETAB
	INTEGER LOSTOT, HISTOT, MONTOT, UUOTOT
	INTEGER IHDRLN, IDATLN, HSTFSP(9)
	INTEGER FILE(13)

	INTEGER I400K, HISMX4, ANY, LNAME, HNAME, UUONAM(2)
	INTEGER SEGMNT, NUMB, LEVEL, PISR, VC, MONIT, OR
C
C	DATA FOR PAGE-FORMATTING ROUTINE
C
	COMMON LINE, OGLOB1, OGLOB2, NMAX
C
C	TO BUILD WITH LARGER DATA BUFFERS, CHANGE DIMENSION OF DATA
C	AND CORRESPONDING NUMBER IN IDATLN
C
	DIMENSION DATA(66000)
	DIMENSION MONTHS(12), LNAME(2), HNAME(2), STATES(32),
     1	ASTRK(100), SEGMNT(2), NUMB(7), UUO(192), OPCOD(512)
C
C
C	THE FOLLOWING EQUIVALENCE REPRESENTS THE LAYOUT OF THE
C	HISTOGRAM FILE, WHICH WILL BE READ INTO DATA WHEN WE
C	CALL THE SUBROUTINE RHIST.
C
C	ENTRIES FOLLOWING BUGS ARE CLEARED ON EVERY CYCLE,
C	AND CYCLE IS CLEARED BEFORE WRITING THE LAST HISTOGRAM.
C
	EQUIVALENCE (DATA(1), HEADLN), (DATA(2), CONFIG(1)),
     1	(DATA(9), TODAY), (DATA(10), NOW), (DATA(11), USERF),
     2	(DATA(12), INTRVL), (DATA(13), INTLVL), (DATA(14), COMENT(1)),
     3	(DATA(24), MONDAT(1)), (DATA(36), LOSDAT(1)),
     4	(DATA(48), HISDAT(1)), (DATA(60), JOBNO), (DATA(61), WCHAN),
     5	(DATA(62), CYCLE), (DATA(63), CPUN), (DATA(64), EXTKLM),
     6	(DATA(65), BUGS), (DATA(66), TOTAL), (DATA(67), PITAB(1)),
     7	(DATA(74), HISTOG(1))

	EQUIVALENCE (MONDAT(1), MONFSP(1)), (MONDAT(10), MONRES),
     1	(MONDAT(11), MONLIM), (MONDAT(12), MONMAX)
	EQUIVALENCE (LOSDAT(1), LOSFSP(1)), (LOSDAT(10), LOSRES),
     1	(LOSDAT(11), LOSLIM), (LOSDAT(12), LOSMAX)
	EQUIVALENCE (HISDAT(1), HISFSP(1)), (HISDAT(10), HISRES),
     1	(HISDAT(11), HISLIM), (HISDAT(12), HISMAX)

C
C	IF CYCLE IS NON-ZERO WHEN WE COMPLETE A HISTOGRAM, IT MEANS
C	THAT WHEN SNOOPY WROTE IT, HE EXPECTED TO WRITE ANOTHER.
C	THEREFORE, WE CALL RHISTN TO GENERATE THE NEXT EXTENSION
C
C
C	NOW FOR LOTS OF DATA STATEMENTS
C
	DATA MONTHS/'JAN ','FEB ','MAR ','APR ','MAY ','JUN ',
     1	'JUL ','AUG ','SEP ','OCT ','NOV ','DEC '/
	DATA STATES/32*'     '/
	DATA I400K/"400000/, ANY/' ANY'/, ASTRK/' ',99*'*'/
	DATA NUMB/' 1',' 2',' 3',' 4',' 5',' 6',' 7'/
	DATA LEVEL/'LEVEL'/, PISR/'PI SR'/, VC/'VC'/,
     1	MONIT/'MONIT'/, OR/'OR'/
C
C	CHANGE THIS IF HEADER LENGTH CHANGES (PLUS ABOVE EQUIVALENCE)
C
	DATA IHDRLN/73/
C
C	THIS IS WHAT TO CHANGE FOR LARGER BUFFERS (PLUS ABOVE DIMENSION)
C
	DATA IDATLN/66000/
C
C	DEFINE THE ENTRIES IN THE UUO TABLE
C	ENTRIES ARE SIXBIT TO GET THEM ALL IN ONE WORD EACH
C	ENTRIES  1-32  ARE UUO'S 40-77
C	ENTRIES 33-192 ARE CALLI'S 0-237
C
       DATA UUO(  1)/"434154540000/
       DATA UUO(  2)/"515651640000/
       DATA UUO(  3)/"202422000000/
       DATA UUO(  4)/"202423000000/
       DATA UUO(  5)/"202424000000/
       DATA UUO(  6)/"202425000000/
       DATA UUO(  7)/"202426000000/
       DATA UUO(  8)/"434154545100/
       DATA UUO(  9)/"576045560000/
       DATA UUO( 10)/"646443415454/
       DATA UUO( 11)/"202522000000/
       DATA UUO( 12)/"202523000000/
       DATA UUO( 13)/"202524000000/
       DATA UUO( 14)/"624556415545/
       DATA UUO( 15)/"515600000000/
       DATA UUO( 16)/"576564000000/
       DATA UUO( 17)/"634564636463/
       DATA UUO( 18)/"636441645700/
       DATA UUO( 19)/"474564636463/
       DATA UUO( 20)/"636441647200/
       DATA UUO( 21)/"515642654600/
       DATA UUO( 22)/"576564426546/
       DATA UUO( 23)/"515660656400/
       DATA UUO( 24)/"576564606564/
       DATA UUO( 25)/"435457634500/
       DATA UUO( 26)/"624554454163/
       DATA UUO( 27)/"556441604500/
       DATA UUO( 28)/"654745644600/
       DATA UUO( 29)/"656345645100/
       DATA UUO( 30)/"656345645700/
       DATA UUO( 31)/"545757536560/
       DATA UUO( 32)/"455664456200/
       DATA UUO( 33)/"624563456400/
       DATA UUO( 34)/"444464515600/
       DATA UUO( 35)/"634564444464/
       DATA UUO( 36)/"444464576564/
       DATA UUO( 37)/"444566435062/
       DATA UUO( 38)/"444464476400/
       DATA UUO( 39)/"474564435062/
       DATA UUO( 40)/"444464625400/
       DATA UUO( 41)/"674151640000/
       DATA UUO( 42)/"435762450000/
       DATA UUO( 43)/"457051640000/
       DATA UUO( 44)/"656460435462/
       DATA UUO( 45)/"444164450000/
       DATA UUO( 46)/"545747515600/
       DATA UUO( 47)/"416062455642/
       DATA UUO( 48)/"545747576564/
       DATA UUO( 49)/"636751644350/
       DATA UUO( 50)/"624541636351/
       DATA UUO( 51)/"645155456200/
       DATA UUO( 52)/"556364515545/
       DATA UUO( 53)/"474564606056/
       DATA UUO( 54)/"646260634564/
       DATA UUO( 55)/"646260524556/
       DATA UUO( 56)/"626556645155/
       DATA UUO( 57)/"605257420000/
       DATA UUO( 58)/"635445456000/
       DATA UUO( 59)/"634564605766/
       DATA UUO( 60)/"604545530000/
       DATA UUO( 61)/"474564545156/
       DATA UUO( 62)/"626556000000/
       DATA UUO( 63)/"634564656760/
       DATA UUO( 64)/"624555416000/
       DATA UUO( 65)/"474564634547/
       DATA UUO( 66)/"474564644142/
       DATA UUO( 67)/"636071000000/
       DATA UUO( 68)/"634564564155/
       DATA UUO( 69)/"645560435762/
       DATA UUO( 70)/"446353435062/
       DATA UUO( 71)/"637163636462/
       DATA UUO( 72)/"525742636462/
       DATA UUO( 73)/"636462656557/
       DATA UUO( 74)/"637163605071/
       DATA UUO( 75)/"466245435056/
       DATA UUO( 76)/"444566647160/
       DATA UUO( 77)/"444566636463/
       DATA UUO( 78)/"444566606056/
       DATA UUO( 79)/"634545530000/
       DATA UUO( 80)/"626464626000/
       DATA UUO( 81)/"545743530000/
       DATA UUO( 82)/"525742636463/
       DATA UUO( 83)/"545743416445/
       DATA UUO( 84)/"675045624500/
       DATA UUO( 85)/"444566564155/
       DATA UUO( 86)/"436454525742/
       DATA UUO( 87)/"475742636462/
       DATA UUO( 88)/"414364516641/
       DATA UUO( 89)/"444541436451/
       DATA UUO( 90)/"506061000000/
       DATA UUO( 91)/"505142456200/
       DATA UUO( 92)/"674153450000/
       DATA UUO( 93)/"435047606056/
       DATA UUO( 94)/"634564656557/
       DATA UUO( 95)/"444566474556/
       DATA UUO( 96)/"576450656362/
       DATA UUO( 97)/"435053414343/
       DATA UUO( 98)/"444566635172/
       DATA UUO( 99)/"444145555756/
       DATA UUO(100)/"525742604553/
       DATA UUO(101)/"416464414350/
       DATA UUO(102)/"444145465156/
       DATA UUO(103)/"466243656557/
       DATA UUO(104)/"444566545655/
       DATA UUO(105)/"604164501600/
       DATA UUO(106)/"554564456216/
       DATA UUO(107)/"556443506216/
       DATA UUO(108)/"524263456416/
       DATA UUO(109)/"605753451600/
       DATA UUO(110)/"646255565716/
       DATA UUO(111)/"646255576016/
       DATA UUO(112)/"624563446616/
       DATA UUO(113)/"655654575316/
       DATA UUO(114)/"445163531600/
       DATA UUO(115)/"446662636416/
       DATA UUO(116)/"446665626316/
       DATA UUO(117)/"706464635316/
       DATA UUO(118)/"434154212116/
       DATA UUO(119)/"556441514416/
       DATA UUO(120)/"515756447016/
       DATA UUO(121)/"435645436416/
       DATA UUO(122)/"556650446216/
       DATA UUO(123)/"456254636416/
       DATA UUO(124)/"634556634516/
       DATA UUO(125)/"435462636416/
       DATA UUO(126)/"605151565116/
       DATA UUO(127)/"605163716316/
       DATA UUO(128)/"444542625316/
       DATA UUO(129)/"605163416616/
       DATA UUO(130)/"605162636416/
       DATA UUO(131)/"516043466216/
       DATA UUO(132)/"516043466316/
       DATA UUO(133)/"516043466116/
       DATA UUO(134)/"604147451600/
       DATA UUO(135)/"636563456416/
       DATA UUO(136)/"435755606416/
       DATA UUO(137)/"634350454416/
       DATA UUO(138)/"455661160000/
       DATA UUO(139)/"444561160000/
       DATA UUO(140)/"455661431600/
       DATA UUO(141)/"644160576016/
       DATA UUO(142)/"465154576016/
       DATA UUO(143)/"434154273016/
       DATA UUO(144)/"565744451600/
       DATA UUO(145)/"456262606416/
       DATA UUO(146)/"415454574316/
       DATA UUO(147)/"604562461600/
       DATA UUO(148)/"445141471600/
       DATA UUO(149)/"446660507116/
       DATA UUO(150)/"476456645616/
       DATA UUO(151)/"476470645616/
       DATA UUO(152)/"414343641600/
       DATA UUO(153)/"446445160000/
       DATA UUO(154)/"444566576016/
       DATA UUO(155)/"636060625516/
       DATA UUO(156)/"554562474516/
       DATA UUO(157)/"656462601600/
       DATA UUO(158)/"605152425116/
       DATA UUO(159)/"635657576016/
       DATA UUO(160)/"646353160000/
       DATA UUO(161)/"534460160000/
       DATA UUO(162)/"616545654516/
       DATA UUO(163)/"624543575616/
       DATA UUO(164)/"605164556216/
       DATA UUO(165)/"414343544716/
       DATA UUO(166)/"566360160000/
       DATA UUO(167)/"566455415616/
       DATA UUO(168)/"445645641600/
       DATA UUO(169)/"634166451600/
       DATA UUO(170)/"435541564416/
       DATA UUO(171)/"605142545316/
       DATA UUO(172)/"634363160000/
       DATA UUO(173)/"634542545316/
       DATA UUO(174)/"436470160000/
       DATA UUO(175)/"605146544716/
       DATA UUO(176)/"516043465516/
       DATA UUO(177)/"545455576016/
       DATA UUO(178)/"544164576016/
       DATA UUO(179)/"535651426416/
       DATA UUO(180)/"435064625616/
       DATA UUO(181)/"456450566416/
       DATA UUO(182)/"455664664316/
       DATA UUO(183)/"564564576016/
       DATA UUO(184)/"222227000000/
       DATA UUO(185)/"222320000000/
       DATA UUO(186)/"222321000000/
       DATA UUO(187)/"222322000000/
       DATA UUO(188)/"222323000000/
       DATA UUO(189)/"222324000000/
       DATA UUO(190)/"222325000000/
       DATA UUO(191)/"222326000000/
       DATA UUO(192)/"645757425147/
C
C	DEFINE ENTRIES IN THE OPCODE TABLE
C	LIKE THE UUO'S, THEY ARE SIXBIT
C	ENTRIES 1-512 CORRESPOND TO MACHINE OPCODES 0-777
C
       DATA OPCOD(  1)/"515454515663/
       DATA OPCOD(  2)/"546565570000/
       DATA OPCOD(  3)/"546565570000/
       DATA OPCOD(  4)/"546565570000/
       DATA OPCOD(  5)/"546565570000/
       DATA OPCOD(  6)/"546565570000/
       DATA OPCOD(  7)/"546565570000/
       DATA OPCOD(  8)/"546565570000/
       DATA OPCOD(  9)/"546565570000/
       DATA OPCOD( 10)/"546565570000/
       DATA OPCOD( 11)/"546565570000/
       DATA OPCOD( 12)/"546565570000/
       DATA OPCOD( 13)/"546565570000/
       DATA OPCOD( 14)/"546565570000/
       DATA OPCOD( 15)/"546565570000/
       DATA OPCOD( 16)/"546565570000/
       DATA OPCOD( 17)/"546565570000/
       DATA OPCOD( 18)/"546565570000/
       DATA OPCOD( 19)/"546565570000/
       DATA OPCOD( 20)/"546565570000/
       DATA OPCOD( 21)/"546565570000/
       DATA OPCOD( 22)/"546565570000/
       DATA OPCOD( 23)/"546565570000/
       DATA OPCOD( 24)/"546565570000/
       DATA OPCOD( 25)/"546565570000/
       DATA OPCOD( 26)/"546565570000/
       DATA OPCOD( 27)/"546565570000/
       DATA OPCOD( 28)/"546565570000/
       DATA OPCOD( 29)/"546565570000/
       DATA OPCOD( 30)/"546565570000/
       DATA OPCOD( 31)/"546565570000/
       DATA OPCOD( 32)/"546565570000/
       DATA OPCOD( 33)/"556565570000/
       DATA OPCOD( 34)/"556565570000/
       DATA OPCOD( 35)/"556565570000/
       DATA OPCOD( 36)/"556565570000/
       DATA OPCOD( 37)/"556565570000/
       DATA OPCOD( 38)/"556565570000/
       DATA OPCOD( 39)/"556565570000/
       DATA OPCOD( 40)/"556565570000/
       DATA OPCOD( 41)/"556565570000/
       DATA OPCOD( 42)/"556565570000/
       DATA OPCOD( 43)/"556565570000/
       DATA OPCOD( 44)/"556565570000/
       DATA OPCOD( 45)/"556565570000/
       DATA OPCOD( 46)/"556565570000/
       DATA OPCOD( 47)/"556565570000/
       DATA OPCOD( 48)/"556565570000/
       DATA OPCOD( 49)/"556565570000/
       DATA OPCOD( 50)/"556565570000/
       DATA OPCOD( 51)/"556565570000/
       DATA OPCOD( 52)/"556565570000/
       DATA OPCOD( 53)/"556565570000/
       DATA OPCOD( 54)/"556565570000/
       DATA OPCOD( 55)/"556565570000/
       DATA OPCOD( 56)/"556565570000/
       DATA OPCOD( 57)/"556565570000/
       DATA OPCOD( 58)/"556565570000/
       DATA OPCOD( 59)/"556565570000/
       DATA OPCOD( 60)/"556565570000/
       DATA OPCOD( 61)/"556565570000/
       DATA OPCOD( 62)/"556565570000/
       DATA OPCOD( 63)/"556565570000/
       DATA OPCOD( 64)/"556565570000/
       DATA OPCOD( 65)/"655245560000/
       DATA OPCOD( 66)/"212021000000/
       DATA OPCOD( 67)/"212022000000/
       DATA OPCOD( 68)/"212023000000/
       DATA OPCOD( 69)/"212024000000/
       DATA OPCOD( 70)/"212025000000/
       DATA OPCOD( 71)/"212026000000/
       DATA OPCOD( 72)/"212027000000/
       DATA OPCOD( 73)/"444641440000/
       DATA OPCOD( 74)/"444663420000/
       DATA OPCOD( 75)/"444655600000/
       DATA OPCOD( 76)/"444644660000/
       DATA OPCOD( 77)/"212124000000/
       DATA OPCOD( 78)/"212125000000/
       DATA OPCOD( 79)/"212126000000/
       DATA OPCOD( 80)/"212127000000/
       DATA OPCOD( 81)/"445557664500/
       DATA OPCOD( 82)/"445557665600/
       DATA OPCOD( 83)/"465170000000/
       DATA OPCOD( 84)/"212223000000/
       DATA OPCOD( 85)/"445557664555/
       DATA OPCOD( 86)/"445557665655/
       DATA OPCOD( 87)/"465170620000/
       DATA OPCOD( 88)/"465464620000/
       DATA OPCOD( 89)/"654641000000/
       DATA OPCOD( 90)/"444656000000/
       DATA OPCOD( 91)/"466343000000/
       DATA OPCOD( 92)/"514260000000/
       DATA OPCOD( 93)/"515444420000/
       DATA OPCOD( 94)/"544442000000/
       DATA OPCOD( 95)/"514460420000/
       DATA OPCOD( 96)/"446042000000/
       DATA OPCOD( 97)/"464144000000/
       DATA OPCOD( 98)/"464144540000/
       DATA OPCOD( 99)/"464144550000/
       DATA OPCOD(100)/"464144420000/
       DATA OPCOD(101)/"464144620000/
       DATA OPCOD(102)/"464144625100/
       DATA OPCOD(103)/"464144625500/
       DATA OPCOD(104)/"464144624200/
       DATA OPCOD(105)/"466342000000/
       DATA OPCOD(106)/"466342540000/
       DATA OPCOD(107)/"466342550000/
       DATA OPCOD(108)/"466342420000/
       DATA OPCOD(109)/"466342620000/
       DATA OPCOD(110)/"466342625100/
       DATA OPCOD(111)/"466342625500/
       DATA OPCOD(112)/"466342624200/
       DATA OPCOD(113)/"465560000000/
       DATA OPCOD(114)/"465560540000/
       DATA OPCOD(115)/"465560550000/
       DATA OPCOD(116)/"465560420000/
       DATA OPCOD(117)/"465560620000/
       DATA OPCOD(118)/"465560625100/
       DATA OPCOD(119)/"465560625500/
       DATA OPCOD(120)/"465560624200/
       DATA OPCOD(121)/"464466000000/
       DATA OPCOD(122)/"464466540000/
       DATA OPCOD(123)/"464466550000/
       DATA OPCOD(124)/"464466420000/
       DATA OPCOD(125)/"464466620000/
       DATA OPCOD(126)/"464466625100/
       DATA OPCOD(127)/"464466625500/
       DATA OPCOD(128)/"464466624200/
       DATA OPCOD(129)/"555766450000/
       DATA OPCOD(130)/"555766455100/
       DATA OPCOD(131)/"555766455500/
       DATA OPCOD(132)/"555766456300/
       DATA OPCOD(133)/"555766630000/
       DATA OPCOD(134)/"555766635100/
       DATA OPCOD(135)/"555766635500/
       DATA OPCOD(136)/"555766636300/
       DATA OPCOD(137)/"555766560000/
       DATA OPCOD(138)/"555766565100/
       DATA OPCOD(139)/"555766565500/
       DATA OPCOD(140)/"555766566300/
       DATA OPCOD(141)/"555766550000/
       DATA OPCOD(142)/"555766555100/
       DATA OPCOD(143)/"555766555500/
       DATA OPCOD(144)/"555766556300/
       DATA OPCOD(145)/"515565540000/
       DATA OPCOD(146)/"515565545100/
       DATA OPCOD(147)/"515565545500/
       DATA OPCOD(148)/"515565544200/
       DATA OPCOD(149)/"556554000000/
       DATA OPCOD(150)/"556554510000/
       DATA OPCOD(151)/"556554550000/
       DATA OPCOD(152)/"556554420000/
       DATA OPCOD(153)/"514451660000/
       DATA OPCOD(154)/"514451665100/
       DATA OPCOD(155)/"514451665500/
       DATA OPCOD(156)/"514451664200/
       DATA OPCOD(157)/"445166000000/
       DATA OPCOD(158)/"445166510000/
       DATA OPCOD(159)/"445166550000/
       DATA OPCOD(160)/"445166420000/
       DATA OPCOD(161)/"416350000000/
       DATA OPCOD(162)/"625764000000/
       DATA OPCOD(163)/"546350000000/
       DATA OPCOD(164)/"524646570000/
       DATA OPCOD(165)/"416350430000/
       DATA OPCOD(166)/"625764430000/
       DATA OPCOD(167)/"546350430000/
       DATA OPCOD(168)/"222427000000/
       DATA OPCOD(169)/"457043500000/
       DATA OPCOD(170)/"425464000000/
       DATA OPCOD(171)/"415742526000/
       DATA OPCOD(172)/"415742525600/
       DATA OPCOD(173)/"526263640000/
       DATA OPCOD(174)/"524643540000/
       DATA OPCOD(175)/"704364000000/
       DATA OPCOD(176)/"554160000000/
       DATA OPCOD(177)/"606563505200/
       DATA OPCOD(178)/"606563500000/
       DATA OPCOD(179)/"605760000000/
       DATA OPCOD(180)/"605760520000/
       DATA OPCOD(181)/"526362000000/
       DATA OPCOD(182)/"526360000000/
       DATA OPCOD(183)/"526341000000/
       DATA OPCOD(184)/"526241000000/
       DATA OPCOD(185)/"414444000000/
       DATA OPCOD(186)/"414444510000/
       DATA OPCOD(187)/"414444550000/
       DATA OPCOD(188)/"414444420000/
       DATA OPCOD(189)/"636542000000/
       DATA OPCOD(190)/"636542510000/
       DATA OPCOD(191)/"636542550000/
       DATA OPCOD(192)/"636542420000/
       DATA OPCOD(193)/"434151000000/
       DATA OPCOD(194)/"434151540000/
       DATA OPCOD(195)/"434151450000/
       DATA OPCOD(196)/"434151544500/
       DATA OPCOD(197)/"434151410000/
       DATA OPCOD(198)/"434151474500/
       DATA OPCOD(199)/"434151560000/
       DATA OPCOD(200)/"434151470000/
       DATA OPCOD(201)/"434155000000/
       DATA OPCOD(202)/"434155540000/
       DATA OPCOD(203)/"434155450000/
       DATA OPCOD(204)/"434155544500/
       DATA OPCOD(205)/"434155410000/
       DATA OPCOD(206)/"434155474500/
       DATA OPCOD(207)/"434155560000/
       DATA OPCOD(208)/"434155470000/
       DATA OPCOD(209)/"526555600000/
       DATA OPCOD(210)/"526555605400/
       DATA OPCOD(211)/"526555604500/
       DATA OPCOD(212)/"526555605445/
       DATA OPCOD(213)/"526555604100/
       DATA OPCOD(214)/"526555604745/
       DATA OPCOD(215)/"526555605600/
       DATA OPCOD(216)/"526555604700/
       DATA OPCOD(217)/"635351600000/
       DATA OPCOD(218)/"635351605400/
       DATA OPCOD(219)/"635351604500/
       DATA OPCOD(220)/"635351605445/
       DATA OPCOD(221)/"635351604100/
       DATA OPCOD(222)/"635351604745/
       DATA OPCOD(223)/"635351605600/
       DATA OPCOD(224)/"635351604700/
       DATA OPCOD(225)/"415752000000/
       DATA OPCOD(226)/"415752540000/
       DATA OPCOD(227)/"415752450000/
       DATA OPCOD(228)/"415752544500/
       DATA OPCOD(229)/"415752410000/
       DATA OPCOD(230)/"415752474500/
       DATA OPCOD(231)/"415752560000/
       DATA OPCOD(232)/"415752470000/
       DATA OPCOD(233)/"415763000000/
       DATA OPCOD(234)/"415763540000/
       DATA OPCOD(235)/"415763450000/
       DATA OPCOD(236)/"415763544500/
       DATA OPCOD(237)/"415763410000/
       DATA OPCOD(238)/"415763474500/
       DATA OPCOD(239)/"415763560000/
       DATA OPCOD(240)/"415763470000/
       DATA OPCOD(241)/"635752000000/
       DATA OPCOD(242)/"635752540000/
       DATA OPCOD(243)/"635752450000/
       DATA OPCOD(244)/"635752544500/
       DATA OPCOD(245)/"635752410000/
       DATA OPCOD(246)/"635752474500/
       DATA OPCOD(247)/"635752560000/
       DATA OPCOD(248)/"635752470000/
       DATA OPCOD(249)/"635763000000/
       DATA OPCOD(250)/"635763540000/
       DATA OPCOD(251)/"635763450000/
       DATA OPCOD(252)/"635763544500/
       DATA OPCOD(253)/"635763410000/
       DATA OPCOD(254)/"635763474500/
       DATA OPCOD(255)/"635763560000/
       DATA OPCOD(256)/"635763470000/
       DATA OPCOD(257)/"634564720000/
       DATA OPCOD(258)/"634564725100/
       DATA OPCOD(259)/"634564725500/
       DATA OPCOD(260)/"634564724200/
       DATA OPCOD(261)/"415644000000/
       DATA OPCOD(262)/"415644510000/
       DATA OPCOD(263)/"415644550000/
       DATA OPCOD(264)/"415644420000/
       DATA OPCOD(265)/"415644434100/
       DATA OPCOD(266)/"415644434151/
       DATA OPCOD(267)/"415644434155/
       DATA OPCOD(268)/"415644434142/
       DATA OPCOD(269)/"634564550000/
       DATA OPCOD(270)/"634564555100/
       DATA OPCOD(271)/"634564555500/
       DATA OPCOD(272)/"634564554200/
       DATA OPCOD(273)/"415644435500/
       DATA OPCOD(274)/"415644435551/
       DATA OPCOD(275)/"415644435555/
       DATA OPCOD(276)/"415644435542/
       DATA OPCOD(277)/"634564410000/
       DATA OPCOD(278)/"634564415100/
       DATA OPCOD(279)/"634564415500/
       DATA OPCOD(280)/"634564414200/
       DATA OPCOD(281)/"705762000000/
       DATA OPCOD(282)/"705762510000/
       DATA OPCOD(283)/"705762550000/
       DATA OPCOD(284)/"705762420000/
       DATA OPCOD(285)/"515762000000/
       DATA OPCOD(286)/"515762510000/
       DATA OPCOD(287)/"515762550000/
       DATA OPCOD(288)/"515762420000/
       DATA OPCOD(289)/"415644434200/
       DATA OPCOD(290)/"415644434251/
       DATA OPCOD(291)/"415644434255/
       DATA OPCOD(292)/"415644434242/
       DATA OPCOD(293)/"456166000000/
       DATA OPCOD(294)/"456166510000/
       DATA OPCOD(295)/"456166550000/
       DATA OPCOD(296)/"456166420000/
       DATA OPCOD(297)/"634564434100/
       DATA OPCOD(298)/"634564434151/
       DATA OPCOD(299)/"634564434155/
       DATA OPCOD(300)/"634564434142/
       DATA OPCOD(301)/"576243410000/
       DATA OPCOD(302)/"576243415100/
       DATA OPCOD(303)/"576243415500/
       DATA OPCOD(304)/"576243414200/
       DATA OPCOD(305)/"634564435500/
       DATA OPCOD(306)/"634564435551/
       DATA OPCOD(307)/"634564435555/
       DATA OPCOD(308)/"634564435542/
       DATA OPCOD(309)/"576243550000/
       DATA OPCOD(310)/"576243555100/
       DATA OPCOD(311)/"576243555500/
       DATA OPCOD(312)/"576243554200/
       DATA OPCOD(313)/"576243420000/
       DATA OPCOD(314)/"576243425100/
       DATA OPCOD(315)/"576243425500/
       DATA OPCOD(316)/"576243424200/
       DATA OPCOD(317)/"634564570000/
       DATA OPCOD(318)/"634564575100/
       DATA OPCOD(319)/"634564575500/
       DATA OPCOD(320)/"634564574200/
       DATA OPCOD(321)/"505454000000/
       DATA OPCOD(322)/"505454510000/
       DATA OPCOD(323)/"505454550000/
       DATA OPCOD(324)/"505454630000/
       DATA OPCOD(325)/"506254000000/
       DATA OPCOD(326)/"506254510000/
       DATA OPCOD(327)/"506254550000/
       DATA OPCOD(328)/"506254630000/
       DATA OPCOD(329)/"505454720000/
       DATA OPCOD(330)/"505454725100/
       DATA OPCOD(331)/"505454725500/
       DATA OPCOD(332)/"505454726300/
       DATA OPCOD(333)/"506254720000/
       DATA OPCOD(334)/"506254725100/
       DATA OPCOD(335)/"506254725500/
       DATA OPCOD(336)/"506254726300/
       DATA OPCOD(337)/"505454570000/
       DATA OPCOD(338)/"505454575100/
       DATA OPCOD(339)/"505454575500/
       DATA OPCOD(340)/"505454576300/
       DATA OPCOD(341)/"506254570000/
       DATA OPCOD(342)/"506254575100/
       DATA OPCOD(343)/"506254575500/
       DATA OPCOD(344)/"506254576300/
       DATA OPCOD(345)/"505454450000/
       DATA OPCOD(346)/"505454455100/
       DATA OPCOD(347)/"505454455500/
       DATA OPCOD(348)/"505454456300/
       DATA OPCOD(349)/"506254450000/
       DATA OPCOD(350)/"506254455100/
       DATA OPCOD(351)/"506254455500/
       DATA OPCOD(352)/"506254456300/
       DATA OPCOD(353)/"506262000000/
       DATA OPCOD(354)/"506262510000/
       DATA OPCOD(355)/"506262550000/
       DATA OPCOD(356)/"506262630000/
       DATA OPCOD(357)/"505462000000/
       DATA OPCOD(358)/"505462510000/
       DATA OPCOD(359)/"505462550000/
       DATA OPCOD(360)/"505462630000/
       DATA OPCOD(361)/"506262720000/
       DATA OPCOD(362)/"506262725100/
       DATA OPCOD(363)/"506262725500/
       DATA OPCOD(364)/"506262726300/
       DATA OPCOD(365)/"505462720000/
       DATA OPCOD(366)/"505462725100/
       DATA OPCOD(367)/"505462725500/
       DATA OPCOD(368)/"505462726300/
       DATA OPCOD(369)/"506262570000/
       DATA OPCOD(370)/"506262575100/
       DATA OPCOD(371)/"506262575500/
       DATA OPCOD(372)/"506262576300/
       DATA OPCOD(373)/"505462570000/
       DATA OPCOD(374)/"505462575100/
       DATA OPCOD(375)/"505462575500/
       DATA OPCOD(376)/"505462576300/
       DATA OPCOD(377)/"506262450000/
       DATA OPCOD(378)/"506262455100/
       DATA OPCOD(379)/"506262455500/
       DATA OPCOD(380)/"506262456300/
       DATA OPCOD(381)/"505462450000/
       DATA OPCOD(382)/"505462455100/
       DATA OPCOD(383)/"505462455500/
       DATA OPCOD(384)/"505462456300/
       DATA OPCOD(385)/"646256000000/
       DATA OPCOD(386)/"645456000000/
       DATA OPCOD(387)/"646256450000/
       DATA OPCOD(388)/"645456450000/
       DATA OPCOD(389)/"646256410000/
       DATA OPCOD(390)/"645456410000/
       DATA OPCOD(391)/"646256560000/
       DATA OPCOD(392)/"645456560000/
       DATA OPCOD(393)/"644456000000/
       DATA OPCOD(394)/"646356000000/
       DATA OPCOD(395)/"644456450000/
       DATA OPCOD(396)/"646356450000/
       DATA OPCOD(397)/"644456410000/
       DATA OPCOD(398)/"646356410000/
       DATA OPCOD(399)/"644456560000/
       DATA OPCOD(400)/"646356560000/
       DATA OPCOD(401)/"646272000000/
       DATA OPCOD(402)/"645472000000/
       DATA OPCOD(403)/"646272450000/
       DATA OPCOD(404)/"645472450000/
       DATA OPCOD(405)/"646272410000/
       DATA OPCOD(406)/"645472410000/
       DATA OPCOD(407)/"646272560000/
       DATA OPCOD(408)/"645472560000/
       DATA OPCOD(409)/"644472000000/
       DATA OPCOD(410)/"646372000000/
       DATA OPCOD(411)/"644472450000/
       DATA OPCOD(412)/"646372450000/
       DATA OPCOD(413)/"644472410000/
       DATA OPCOD(414)/"646372410000/
       DATA OPCOD(415)/"644472560000/
       DATA OPCOD(416)/"646372560000/
       DATA OPCOD(417)/"646243000000/
       DATA OPCOD(418)/"645443000000/
       DATA OPCOD(419)/"646243450000/
       DATA OPCOD(420)/"645443450000/
       DATA OPCOD(421)/"646243410000/
       DATA OPCOD(422)/"645443410000/
       DATA OPCOD(423)/"646243560000/
       DATA OPCOD(424)/"645443560000/
       DATA OPCOD(425)/"644443000000/
       DATA OPCOD(426)/"646343000000/
       DATA OPCOD(427)/"644443450000/
       DATA OPCOD(428)/"646343450000/
       DATA OPCOD(429)/"644443410000/
       DATA OPCOD(430)/"646343410000/
       DATA OPCOD(431)/"644443560000/
       DATA OPCOD(432)/"646343560000/
       DATA OPCOD(433)/"646257000000/
       DATA OPCOD(434)/"645457000000/
       DATA OPCOD(435)/"646257450000/
       DATA OPCOD(436)/"645457450000/
       DATA OPCOD(437)/"646257410000/
       DATA OPCOD(438)/"645457410000/
       DATA OPCOD(439)/"646257560000/
       DATA OPCOD(440)/"645457560000/
       DATA OPCOD(441)/"644457000000/
       DATA OPCOD(442)/"646357000000/
       DATA OPCOD(443)/"644457450000/
       DATA OPCOD(444)/"646357450000/
       DATA OPCOD(445)/"644457410000/
       DATA OPCOD(446)/"646357410000/
       DATA OPCOD(447)/"644457560000/
       DATA OPCOD(448)/"646357560000/
       DATA OPCOD(449)/"272020000000/
       DATA OPCOD(450)/"272021000000/
       DATA OPCOD(451)/"272022000000/
       DATA OPCOD(452)/"272023000000/
       DATA OPCOD(453)/"272024000000/
       DATA OPCOD(454)/"272025000000/
       DATA OPCOD(455)/"272026000000/
       DATA OPCOD(456)/"272027000000/
       DATA OPCOD(457)/"272120000000/
       DATA OPCOD(458)/"272121000000/
       DATA OPCOD(459)/"272122000000/
       DATA OPCOD(460)/"272123000000/
       DATA OPCOD(461)/"272124000000/
       DATA OPCOD(462)/"272125000000/
       DATA OPCOD(463)/"272126000000/
       DATA OPCOD(464)/"272127000000/
       DATA OPCOD(465)/"272220000000/
       DATA OPCOD(466)/"272221000000/
       DATA OPCOD(467)/"272222000000/
       DATA OPCOD(468)/"272223000000/
       DATA OPCOD(469)/"272224000000/
       DATA OPCOD(470)/"272225000000/
       DATA OPCOD(471)/"272226000000/
       DATA OPCOD(472)/"272227000000/
       DATA OPCOD(473)/"272320000000/
       DATA OPCOD(474)/"272321000000/
       DATA OPCOD(475)/"272322000000/
       DATA OPCOD(476)/"272323000000/
       DATA OPCOD(477)/"272324000000/
       DATA OPCOD(478)/"272325000000/
       DATA OPCOD(479)/"272326000000/
       DATA OPCOD(480)/"272327000000/
       DATA OPCOD(481)/"272420000000/
       DATA OPCOD(482)/"272421000000/
       DATA OPCOD(483)/"272422000000/
       DATA OPCOD(484)/"272423000000/
       DATA OPCOD(485)/"272424000000/
       DATA OPCOD(486)/"272425000000/
       DATA OPCOD(487)/"272426000000/
       DATA OPCOD(488)/"272427000000/
       DATA OPCOD(489)/"272520000000/
       DATA OPCOD(490)/"272521000000/
       DATA OPCOD(491)/"272522000000/
       DATA OPCOD(492)/"272523000000/
       DATA OPCOD(493)/"272524000000/
       DATA OPCOD(494)/"272525000000/
       DATA OPCOD(495)/"272526000000/
       DATA OPCOD(496)/"272527000000/
       DATA OPCOD(497)/"272620000000/
       DATA OPCOD(498)/"272621000000/
       DATA OPCOD(499)/"272622000000/
       DATA OPCOD(500)/"272623000000/
       DATA OPCOD(501)/"272624000000/
       DATA OPCOD(502)/"272625000000/
       DATA OPCOD(503)/"272626000000/
       DATA OPCOD(504)/"272627000000/
       DATA OPCOD(505)/"272720000000/
       DATA OPCOD(506)/"272721000000/
       DATA OPCOD(507)/"272722000000/
       DATA OPCOD(508)/"272723000000/
       DATA OPCOD(509)/"272724000000/
       DATA OPCOD(510)/"272725000000/
       DATA OPCOD(511)/"272726000000/
       DATA OPCOD(512)/"272727000000/
	CYCLE = 0
100	IF (CYCLE .NE. 0) CALL RHISTN(HSTFSP)
	CALL RHIST(DATA,IDATLN,HSTFSP)
C
	IF (BUGS .NE. 0) PRINT 9900, BUGS
C
C	CHECK FOR THE CORRECT FORMAT IN HIST.DAT
C
	IF (HEADLN .NE. IHDRLN) GO TO 900
	ITYPE = USERF - USERF/8*8
	NOPC = 0
	IF (USERF/8 .NE. USERF/16*2) NOPC = 512
	NUUO = 0
	IF (USERF/16 .NE. USERF/32*2) NUUO = 192
	NWS = 0
	IF (ITYPE .EQ. 4) NWS = 32
	IF (HEADLN+MONLIM+LOSLIM+HISLIM+NOPC+NWS+NUUO .GT. IDATLN)
     1	GO TO 910
	IF (TOTAL .EQ. 0) GO TO 920
	PRINT 9001
	LINE=1
C
C	DISPATCH ACCORDING TO THE KIND OF DATA TAKEN
C
	GO TO (1000,2000,3000,4000), ITYPE
C
C	ANALYSIS OF TIME AT SOME PI LEVEL
C
1000	CONTINUE
	IF (INTLVL .GT. 0) PRINT 9002, INTLVL, MONRES
	IF (INTLVL .EQ. -1) PRINT 9007, MONRES
	LINE = LINE + 1
	ASSIGN 1010 TO NEXT
	GO TO 110
1010	X = 100. * PITOT / TOTAL
	PRINT 9015, X
	LINE = LINE + 2
	IF (INTLVL .EQ. -1) GO TO 1020
	SEGMNT(1) = LEVEL
	SEGMNT(2) = NUMB(INTLVL)
	GO TO 2020
1020	SEGMNT(1) = PISR
	SEGMNT(2) = VC
	GO TO 2020
C
C	ANALYSIS OF TIME IN MONITOR MODE
C
2000	CONTINUE
	IF (INTLVL .EQ. 0) PRINT 9003, MONRES
	IF (INTLVL .EQ. -1) PRINT 9004, MONRES
	LINE = LINE + 1
	ASSIGN 2010 TO NEXT
	GO TO 110
2010	IF (INTLVL .EQ. 0) X = 100. * MONTOT / TOTAL
	IF (INTLVL .EQ. -1) X = 100. * (MONTOT - PITOT) / TOTAL
	PRINT 9016, X
	LINE = LINE + 2
	X=100. * PITOT / TOTAL
	PRINT 9020, X
	LINE = LINE + 1
	SEGMNT(1) = MONIT
	SEGMNT(2) = OR
2020	DO 2030 I=1,7
	IF (PITAB(I) .EQ. 0) GO TO 2030
	X=100. * PITAB(I) / TOTAL
	PRINT 9021, X, I
	LINE = LINE + 1
2030	CONTINUE
2050	X = MONTOT
	ASSIGN 2060 TO NEXT
	GO TO 300
2060	ASSIGN 2100 TO NEXT
	IF (NUUO .NE. 0) GO TO 400
C
C	PRINT MONITOR HISTOGRAM
C
2100	IF ((MONMAX .EQ. 0) .OR. (MONTOT .EQ. 0)) GO TO 100
	ASSIGN 2110 TO NEXT
	GO TO 200
2110	CALL PRHIST(MONFSP, MONMAX, MONLIM, MONRES, HISTOG(MONTAB),
     1	MONTOT, TOTAL, SEGMNT, 'SYS',0)
	GO TO 100
C
C	ANALYSIS OF TIME SPENT BY SOME CUSP
C
3000	CONTINUE
	LNAME(1) = ANY
	LNAME(2) = 0
	IF (LOSNAM .NE. -1) CALL TRAN67(LOSNAM, LNAME)
	HNAME(1) = ANY
	HNAME(2) = 0
	IF (HISNAM .NE. -1) CALL TRAN67(HISNAM, HNAME)
	PRINT 9005, LNAME(1), LNAME(2), LOSRES, HNAME(1), HNAME(2), HISRES
	LINE = LINE + 2
	ASSIGN 3005 TO NEXT
	GO TO 110
3005	IF (NUUO .EQ. 0) GO TO 3010
	MONTOT = UUOTOT
	PRINT 9017
	LINE = LINE + 3
3010	X=100. * MONTOT / TOTAL
	PRINT 9016, X
	LINE = LINE + 2
	PRINT 9018, LNAME(1), LNAME(2), HNAME(1), HNAME(2)
	LINE = LINE + 1
	X=100. * LOSTOT / TOTAL
	Y=100. * HISTOT / TOTAL
	PRINT 9019, X, Y
	LINE = LINE + 1
	JOBTOT = LOSTOT + HISTOT + MONTOT
	IF (NUUO .NE. 0) JOBTOT = LOSTOT + HISTOT
	IF (JOBTOT .EQ. 0) GO TO 920
	X= 100. * LOSTOT / JOBTOT
	Y= 100. * HISTOT / JOBTOT
	Z= 100. * MONTOT / JOBTOT
	PRINT 9022, X, Y, Z
	LINE = LINE + 4
	IMIN = JOBTOT / (100000/INTRVL) / 60
	SEC = JOBTOT / (100000./INTRVL) - IMIN*60
	PRINT 9023, IMIN, SEC
	LINE = LINE + 1
	IF ((NWS .EQ. 0) .OR. (MAXWS .EQ. 0)) GO TO 3050
C
C	LIST TIMES IN WAIT STATES FOR JOB
C
	CALL STCODE(STATES)
	PRINT 9030
	LINE = LINE + 3
	Y = 100. / TOTAL
	Z = 90. / MAXWS
	DO 3020 I=QUETAB, QUETAB+NWS-1
	HIST = HISTOG(I)
	IF (HIST .EQ. 0) GO TO 3020
	X = HIST * Y
	N = HIST * Z + 1
	J = I - QUETAB + 1
	JFAKE = J - 1
	PRINT 9031, X, STATES(J), JFAKE, (ASTRK(J), J=1,N)
	LINE = LINE + 1
3020	CONTINUE
3050	X = LOSTOT + HISTOT
	ASSIGN 3060 TO NEXT
	GO TO 300
3060	ASSIGN 3100 TO NEXT
	IF (NUUO .NE. 0) GO TO 400
C
C	PRINT HISTOGRAM FOR LOW SEGMENT
C
3100	CONTINUE
	IF ((LOSMAX .EQ. 0) .OR. (LOSTOT .EQ. 0)) GO TO 3115
	ASSIGN 3110 TO NEXT
	GO TO 200
3110	PRINT 9050, I, LNAME(1), LNAME(2), LOSMAX
	IMNF=1
	IF(LOSMAX.GT.I400K) IMNF=0
	CALL PRHIST (LOSFSP, LOSMAX, LOSLIM, LOSRES, HISTOG(LOSTAB),
     1	LOSTOT, JOBTOT, 'LOW SEG','JOB',IMNF)
C
C	HISTOGRAM FOR HIGH SEGMENT
C
3115	IF ((HISMAX .EQ. 0) .OR. (HISTOT .EQ. 0)) GO TO 3125
	HISMX4 = HISMAX + I400K
	ASSIGN 3120 TO NEXT
	GO TO 200
3120	PRINT 9051, I, HNAME(1), HNAME(2), HISMX4
	CALL PRHIST (HISFSP, HISMX4, HISLIM, HISRES, HISTOG(HISTAB),
     1	HISTOT, JOBTOT, 'HIGH SEG','JOB',1)
C
C	PRINT MONITOR HISTOGRAM
C
3125	IF ((MONMAX .EQ. 0) .OR. (MONTOT .EQ. 0) .OR. (NUUO .NE. 0))
     1	GO TO 100
	ASSIGN 3130 TO NEXT
	GO TO 200
3130	CALL PRHIST (MONFSP, MONMAX, MONLIM, MONRES,
     1	HISTOG(MONTAB), MONTOT, JOBTOT, 'MONITOR', 'JOB', 0)
	GO TO 100
C
C	ANALYZE TIME SPENT IN SOME JOB
C
4000	CONTINUE
	PRINT 9006, JOBNO
	LINE = LINE + 1
	GO TO 3000
C
C	COMMON INITIALIZATION FOR ALL FUNCTIONS
C
110	IF (COMENT(1) .EQ. 0) GO TO 115
	PRINT 9014, (COMENT(I), I=1,10)
	LINE = LINE + 2
115	IF (CPUN.GE.0) PRINT 9010, INTRVL, CPUN, WCHAN, (CONFIG(I), I=1,7)
	IF (CPUN.LT.0) PRINT 9009, INTRVL, WCHAN, (CONFIG(I), I=1,7)
	LINE = LINE + 6
	IYEAR= TODAY / 31 / 12 + 1964
	IMONTH= TODAY / 31 - (IYEAR-1964) * 12
	IDAY= TODAY+1 - (TODAY/31) * 31
	IHOUR= NOW  / 1000 / 60 / 60
	IMIN= NOW / 1000 / 60 - IHOUR * 60
	ISEC= NOW / 1000 - (NOW/1000/60) * 60
	PRINT 9011, IHOUR, IMIN, ISEC, MONTHS(IMONTH+1), IDAY, IYEAR
	LINE = LINE + 1
	IMIN= TOTAL / (100000/INTRVL) / 60
	SEC= TOTAL / (100000./INTRVL) - IMIN * 60
	PRINT 9012, IMIN, SEC
	LINE = LINE + 1
	CALL TRANFS(HSTFSP, FILE)
	PRINT 9013, (FILE(I), I=1,13)
	LINE = LINE + 1
C
C	COMPUTE SOME SUBTOTALS AND SETUP POINTERS INTO HISTOG
C
	NMAX=0
	LOSTOT=0
	LOSTAB=1
	IF (LOSLIM .EQ. 0) GO TO 130
	DO 120 I=LOSTAB,LOSLIM
	IF (NMAX .LT. HISTOG(I)) NMAX = HISTOG(I)
120	LOSTOT= LOSTOT + HISTOG(I)
130	HISTOT=0
	HISTAB= LOSTAB + LOSLIM
	IF (HISLIM .EQ. 0) GO TO 150
	DO 140 I=HISTAB,HISTAB+HISLIM-1
	IF (NMAX .LT. HISTOG(I)) NMAX = HISTOG(I)
140	HISTOT= HISTOT + HISTOG(I)
150	MONTOT=0
	MONTAB= HISTAB + HISLIM
	IF (MONLIM .EQ. 0) GO TO 162
	DO 160 I=MONTAB,MONTAB+MONLIM-1
	IF (NMAX .LT. HISTOG(I)) NMAX = HISTOG(I)
160	MONTOT= MONTOT + HISTOG(I)
162	UUOTAB = MONTAB + MONLIM
	UUOTOT = 0
	MAXUUO = 0
	IF (NUUO .EQ. 0) GO TO 170
	DO 164 I=UUOTAB, UUOTAB+NUUO-1
	IF (MAXUUO .LT. HISTOG(I)) MAXUUO = HISTOG(I)
164	UUOTOT = UUOTOT + HISTOG(I)
170	OPCTAB = UUOTAB + NUUO
	MAXOPC = 0
	IF (NOPC .EQ. 0) GO TO 174
	IOPCNT=0
	DO 172 I=OPCTAB, OPCTAB+NOPC-1
	IOPCNT=IOPCNT+HISTOG(I)
172	IF (HISTOG(I) .GT. MAXOPC) MAXOPC = HISTOG(I)
174	QUETAB = OPCTAB + NOPC
	MAXWS = 0
	IF (NWS .EQ. 0) GO TO 180
	DO 176 I=QUETAB, QUETAB+NWS-1
176	IF (HISTOG(I) .GT. MAXWS) MAXWS = HISTOG(I)
180	PITOT=0
	DO 190 I=1,7
190	PITOT= PITOT + PITAB(I)
	GO TO NEXT
C
C	PAGE FORMATTING
C
200	IF (LINE .GT. 40) GO TO 210
	I = 0
	LINE = LINE + 2
	GO TO NEXT
210	I = 1
	LINE = 1
	GO TO NEXT
C
300	IF ((NOPC .EQ. 0) .OR. (MAXOPC .EQ. 0)) GO TO NEXT
C
C	PRINT OPCODE USAGE
C
	PRINT 9040
	LINE = LINE + 3
	Y = 100. / IOPCNT
	Z = 90. / MAXOPC
	DO 310 I=0,511
	X = HISTOG(I+OPCTAB)
	IF (X .EQ. 0) GO TO 310
	N = X * Z + 1
	X = X * Y
	UUOFOO=OPCOD(I+1)
	CALL TRAN6B(UUOFOO, UUONAM)
	PRINT 9044, UUONAM(1), UUONAM(2), X, (ASTRK(J), J=1,N)
	LINE = LINE + 1
	IF (LINE .LT. 50) GO TO 310
	PRINT 9042
	LINE = 2
310	CONTINUE
	GO TO NEXT
C
C	PRINT UUO TIMES
C
400	PRINT 9043
	LINE = LINE + 3
	Y = 100. / UUOTOT
	Z = 90. / MAXUUO
	DO 410 I=UUOTAB, UUOTAB+NUUO-1
	HIST = HISTOG(I)
	IF (HIST .EQ. 0) GO TO 410
	X = HIST * Y
	N = HIST * Z + 1
	UUOFOO=UUO(I-UUOTAB+1)
	CALL TRAN6B (UUOFOO, UUONAM)
	PRINT 9044, UUONAM(1), UUONAM(2), X, (ASTRK(J), J=1,N)
	LINE = LINE + 1
	IF (LINE .LT. 50) GO TO 410
	PRINT 9045
	LINE = 2
410	CONTINUE
	GO TO NEXT
C
C	ERRORS
C
900	IF (HEADLN .EQ. 0) CALL EXIT
	PRINT 9901
	TYPE 9901
	GO TO 100
910	I=HEADLN+MONLIM+LOSLIM+HISLIM+NOPC+NWS+NUUO
	PRINT 9902, I
	TYPE 9902, I
	GO TO 100
920	PRINT 9903
	GO TO 100
C	FORMATS
C
9001	FORMAT('1SNOOPY/TATTLE V2: CPU TIME BREAKDOWN')
9002	FORMAT(' FOR INTERRUPT LEVEL',I2,' BY',I4,'-WORD REGIONS.')
9003	FORMAT(' FOR MONITOR (EXCLUSIVE OF INTERRUPTS) BY',
     1	I4,'-WORD REGIONS,')
9004	FORMAT(' FOR MONITOR (INCLUDING PI SERVICE) BY',
     1	I4,'-WORD REGIONS.')
9005	FORMAT(' FOR ',A5,A1,' LOW SEGMENT BY',I4,'-WORD REGIONS,'/
     1	' AND ',A5,A1,' HIGH SEGMENT BY',I4,'-WORD REGIONS.')
9006	FORMAT(' FOR JOB NUMBER',I3,' ONLY.')
9007	FORMAT(' FOR INTERRUPT SERVICE BY',I4,'-WORD REGIONS.')
9009	FORMAT('0SAMPLING EVERY',I6,'0 MICRO-SECONDS'/
     1	' WATCHING FROM PI CHANNEL',I2/
     2	' REGIONS WITH NO RECORDED TIME ARE NOT REPORTED.'/
     3	'0TIMING DONE ON ',5A5,' CREATED ',2A5)
9010	FORMAT('0SAMPLING EVERY',I6,'0 MICRO-SECONDS'/
     1	' WATCHING CPU',I2,' FROM PI CHANNEL',I2/
     2	' REGIONS WITH NO RECORDED TIME ARE NOT REPORTED.'/
     3	'0TIMING DONE ON ',5A5,' CREATED ',2A5)
9011	FORMAT(' WATCHED AT ',I2,':',I2,':',I2,' ON ',A4,I2,', ',I4,'.')
9012	FORMAT(' LENGTH OF RUN WAS',I4,' MINUTES, ',F6.3,' SECONDS.')
9013	FORMAT(' HISTOGRAM DATA FROM FILE ',13A5)
9014	FORMAT('0',10A5)
9015	FORMAT('0SYSTEM SPENT',F9.5,'% OF ITS TIME',
     1	' IN INTERRUPT SERVICE, AS FOLLOWS:')
9016	FORMAT('0SYSTEM SPENT',F9.5,'% OF ITS TIME IN MONITOR',
     1	' WITH NO PI IN PROGRESS')
9017	FORMAT('0NOTE: UUO TIME IS ATTRIBUTED BOTH TO MONITOR'/
     1	7X,'AND TO SEGMENT CONTAINING THE UUO.')
9018	FORMAT(' FOR ',A5,A1,' LOW SEGMENT, AND ',
     1	A5,A1,' HIGH SEGMENT')
9019	FORMAT(' ',F8.5,'% IN LOW SEGMENT, AND ',F8.5,'% IN HIGH SEGMENT')
9020	FORMAT(' AND ',F8.5,'% IN INTERRUPT SERVICE, AS FOLLOWS:')
9021	FORMAT(5X,F8.5,'% AT PI LEVEL',I2)
9022	FORMAT('0CUSP SPENT',F9.5,'% IN LOW SEGMENT,'/
     1	11X,F9.5,'% IN HIGH SEGMENT,'/
     2	11X,F9.5,'% IN MONITOR.')
9023	FORMAT(' CUSP ACCUMULATED'I4,' MINUTES, ',F6.3,
     1	' SECONDS OF RUNTIME.')
9030	FORMAT('0JOB SPENT TIME IN WAIT STATES AS FOLLOWS:')
9031	FORMAT(1X,F9.5,'% IN ',A2,'(',O2,')',100A1)
9040	FORMAT('0OPCODE USAGE BREAKDOWN:'/)
9042	FORMAT('1OPCODE USAGE CONTINUED'/)
9043	FORMAT('0UUO TIME BREAKDOWN:'/)
9044	FORMAT(1X,A5,A1,4X,F9.5,'%',100A1)
9045	FORMAT('1UUO TIME CONTINUED'/)
9050	FORMAT(I1,A5,A1,' LOW SEGMENT BREAKDOWN BELOW ',O7,' OCTAL:')
9051	FORMAT(I1,A5,A1,' HIGH SEGMENT BREAKDOWN BELOW ',O7,' OCTAL:')
C
9900	FORMAT(1X,I10,' APR TRAPS RECORDED'/)
9901	FORMAT(' HISTOGRAM FILE FORMAT IS INCORRECT'/)
9902	FORMAT(' HISTOGRAM FILE IS TOO BIG.  ENLARGE DATA TO ',I8/)
9903	FORMAT('0NO COUNTS TAKEN')
C
	END
	SUBROUTINE PRHIST
     1	(FILESP, MAX, LIM, RES, HISTOG, SEGTOT, TOTAL, SEGMNT, TOT,
     2  IMNFLG)
C
C	SUBROUTINE TO PRINT A HISTOGRAM FOR A SEGMENT
C	IT WOULD BE NICE, SOMEDAY, IF THIS ROUTINE ALSO
C	ACCUMULATED MEAN COUNT, THE MEAN OMITTING ZEROS,
C	AND PRINTED REGIONS WITH LOW COUNTS (FOR COLD-SPOT DETECTION).
C
	DIMENSION HISTOG(1), IGLOB(2), LOCAL(2), ASTRK(100), SEGMNT(2),
     1	FILESP(9)
	INTEGER NAME, MAX, LIM, RES, HISTOG, SEGTOT, TOTAL,
     1	OGLOB1, OGLOB2, I400K, FILNAM(13), SYMFLG
	COMMON LINE, OGLOB1, OGLOB2, NMAX
	DATA ASTRK/' ',99*'*'/
	DATA I400K/"400000/
C
C
C	VERY EASY IF LIMIT SMALL ENOUGH, OR TOTAL IN SEGMENT IS ZERO
C
	IF (SEGTOT .EQ. 0) GO TO 170
	IF (LIM .LE. 1) GO TO 160
C
C	LOAD SYMBOL TABLE FOR THE SEGMENT
C
	CALL SYMINT(SYMFLG,FILESP)
	IF (SYMFLG .EQ. 0) GOTO 10
	CALL TRANFS(FILESP, FILNAM)
	PRINT 9023, (FILNAM(I), I=1,13)
	LINE = LINE + 1
C
10	X= 100. / SEGTOT
	Y= 100. / TOTAL
	PRINT 9024, X, SEGMNT(1), SEGMNT(2), Y, TOT
	LINE = LINE + 3
	IADDR = 0
	IF (IMNFLG .EQ. 1  .AND.  MAX .GT. I400K) IADDR = I400K
	OGLOB1 = 0
C
C	PRINT PERCENTAGE TIME SPENT IN EACH REGION
C
	DO 155 I=1,LIM-1
C
C	CHECK FOR NO TIME IN REGION
C
	HIST = HISTOG(I)
	IF (HIST .EQ. 0) GO TO 150
C
C	GET A SYMBOL WHICH PRECEEDS IADDR, RETURN ITS VALUE
C
	CALL SYMSRC (IADDR, IGLOB, LOCAL, IVAL)
C
C	CHECK THAT THIS ADDRESS IS IN SAME MODULE
C	AS LAST ONE WAS
C
	IF ((IGLOB(1) .EQ. OGLOB1) .AND. (IGLOB(2) .EQ. OGLOB2))
     1	GO TO 130
C
C	IS THIS THE FIRST MODULE?
C
	IF (OGLOB1 .EQ. 0) GO TO 110
C
C	NO, PRINT SUBTOTALS FOR PREVIOUS MODULE
C
	X = 100. * SUBTOT / SEGTOT
	Y = 100. * SUBTOT / TOTAL
	PRINT 9030, OGLOB1, OGLOB2, INT(SUBTOT), X, Y
	LINE = LINE + 4
C
C	NEW MODULE, CLEAR SUBTOTAL
C
110	SUBTOT = 0.
	OGLOB1 = IGLOB(1)
	OGLOB2 = IGLOB(2)
	CALL FORM(SEGMNT, TOT, 0)
C
C	PRINT NEW MODULE HEADER UNLESS FORM DID IT
C
	IF (LINE .EQ. 0) GO TO 130
	PRINT 9025, OGLOB1, OGLOB2, SEGMNT(1), SEGMNT(2), TOT
	LINE = LINE + 5
C
C	PRINT A LINE FOR THIS REGION
C
130	X = 100. * HIST / SEGTOT
	Y = 100. * HIST / TOTAL
	SUBTOT = SUBTOT + HIST
	N = HIST * 65. / NMAX + 1
	IOFF = IADDR - IVAL
	PRINT 9027, IADDR, LOCAL(1), LOCAL(2), IOFF, INT(HIST), X, Y,
     1	(ASTRK(J), J=1,N)
	LINE = LINE + 1
	CALL FORM(SEGMNT, TOT, 1)
150	IADDR = IADDR + RES
	IF (IADDR .EQ. "1000000) IADDR = "2000000
155	CONTINUE
	IF (SUBTOT .EQ. 0) GO TO 160
C
C	PRINT FINAL SUBTOTALS
C
	X = 100. * SUBTOT / SEGTOT
	Y = 100. * SUBTOT / TOTAL
	PRINT 9030, OGLOB1, OGLOB2, INT(SUBTOT), X, Y
	LINE = LINE + 4
C
C	PRINT OUT-OF-RANGE COUNT
C
160	HIST = HISTOG(LIM)
	IF (HIST .EQ. 0) RETURN
	X = 100. * HIST / SEGTOT
	Y = 100. * HIST / TOTAL
	PRINT 9031, MAX, X, SEGMNT(1), SEGMNT(2), Y, TOT
	LINE = LINE + 2
	RETURN
C
C	SEGTOT IS ZERO
C
170	PRINT 9032
	LINE = LINE + 2
	RETURN
C
C	FORMATS
C
9023	FORMAT(' SYMBOLS FROM ',13A5)
9024	FORMAT(' TIMING RESOLUTION IS ',F8.5,'% OF ',A5,A4,2X,
     1	F8.5,'% OF ',A3,'.'/)
9025	FORMAT('0  MODULE: ',A5,A1/
     1	'0ADDRESS     LABEL',9X,'COUNT',7X,'% OF ',A5,A4,1X,'% OF ',A3/
     2	' -------     -----',9X,'-----',7X,'------------   --------')
9027	FORMAT(1X,O7,4X,A5,A1,'+',O3,4X,I6,9X,F8.5,'%',4X,F8.5,'%',100A1)
9030	FORMAT('0',1X,A5,A1,' SUBTOTALS:',7X,I6,8X,F9.5,'%',3X,F9.5,'%'//)
9031	FORMAT('0TIME AT ADDRESSES'/' GREATER THAN ',O6,4X,F8.5,
     1	'% OF ',A5,A4,2X,F8.5,'% OF ',A3,'.')
9032	FORMAT('0NO COUNTS TAKEN')
	END
	SUBROUTINE FORM(SEGMNT, TOT, IFLG)
C
C	IFLG DETERMINES IF "CONTINUED" IS TO BE ADDED TO MODULE NAME
C
	COMMON LINE, OGLOB1, OGLOB2
	DIMENSION SEGMNT(2)
C
	IF (LINE .LT. 50) RETURN
	IF (IFLG .EQ. 1) GOTO 100
	PRINT 9026, OGLOB1, OGLOB2, SEGMNT(1), SEGMNT(2), TOT
	LINE = 0
	RETURN
100	PRINT 9027, OGLOB1, OGLOB2, SEGMNT(1), SEGMNT(2), TOT
	LINE = 0
	RETURN
C
9026	FORMAT('1  MODULE: ',A5,A1/
     1	'0ADDRESS     LABEL',9X,'COUNT',7X,'% OF ',A5,A4,1X,'% OF ',A3/
     2	' -------     -----',9X,'-----',7X,'------------   --------')
9027	FORMAT('1  MODULE: ',A5,A1,'  (Continued)',/
     1	'0ADDRESS     LABEL',9X,'COUNT',7X,'% OF ',A5,A4,1X,'% OF ',A3/
     2	' -------     -----',9X,'-----',7X,'------------   --------')
	END
