;[WHO.CTL]
;
; This control file will build and configure WHO for any DECsystem-10.
;
; Sources:	FTIPC.MAC	FTMDC.MAC	FTUFT.MAC
;		GLXXXX.MAC	WHO.MAC		WHOACT.MAC	WHOCHK.MAC
;		WHODPY.MAC	WHOFMT.MAC	WHOGLX.MAC	WHOHAS.MAC
;		WHOIO.MAC	WHOJOB.MAC	WHOLIN.MAC	WHOMAP.MAC
;		WHONOD.MAC	WHOONC.MAC	WHOPRT.MAC	WHOSCN.MAC
;		WHOSRV.MAC	WHOSUM.MAC	WHOSYS.MAC	WHOUUO.MAC
;		WHOVER.MAC
;
; Input:	ACTSYM.UNV	DDT.REL		DPYNEW.REL	JOBDAT.UNV
;		MAP.REL		MACTEN.UNV	MACUNV.UNV	MDCSYM.UNV
;		TCSSYM.UNV	TSGSYM.UNV	UUOSYM.UNV
;
; Output:	WHO.EXE		WHOONC.EXE
;
; Entry points:	DEC	Standard DEC version
;		IPC	IPC monitors (TSGSYM.UNV required)
;		MDC	MDC monitors (MDCSYM.UNV required)
;		TUFTS	Tufts University monitors (TCSSYM.UNV required)
;
; Notes:	The WHO modules load in a particular order.  It must not
;		be changed.  Add new modules after WHO.REL.
DEC::
.COMPILE WHOMAC.MAC
.GOTO WHO

IPC::
.COMPILE FTIPC.MAC+WHOMAC.MAC
.GOTO WHO

MDC::
.COMPILE FTMDC.MAC+WHOMAC.MAC
.GOTO WHO

TUFTS::
.COMPILE FTUFT.MAC+WHOMAC.MAC
.GOTO WHO

WHO::
.COMPILE @WHO

.R LINK
*WHOONC/SAVE = /LOCALS /SYMSEG:HIGH -
*WHOVER, WHOACT, WHOCHK, WHODPY, WHOFMT, -
*WHOGLX, WHOHAS, WHOIO,  WHOJOB, WHOLIN, -
*WHOMAP, WHONOD, WHOPRT, WHOSCN, WHOSRV, -
*WHOSRT, WHOSTR, WHOSUM, WHOSYS, WHOTXT, -
*WHOUNI, WHOUUO, WHO,    GLXXXX, -
*REL:DPYNEW, -
*REL:MAP, -
*REL:SCAN/SEARCH, -
*REL:HELPER, -
*WHOONC, REL:DDT /GO

.GET WHOONC
.DDT
=DONE 6/
*JFCL
=
.SAVE WHOONC

.RUN WHOONC
*NO	;HELP
*LONG	;DIALOG MODE
*	;MONITOR
*NO	;DDT
*NO	;SYMBOLS
*	;SAVE FILE
*YES	;DEFAULT INTERNALS
*YES	;DEFAULT USER
.IF (ERROR) .SSAVE ;IGNORE ERRORS FOR NOW

.DIRECT /CHECK /SLOW WHO.EXE, WHOONC.EXE

.PLEASE	WHO Assembly Successful
.GOTO END

%CERR:: .GOTO ERROR
%ERR::  .GOTO ERROR
%TERR:: .GOTO ERROR

ERROR:: .PLEASE Error during WHO assembly

END::
%FIN::
;[End of WHO.CTL]
