//
//	This Unit provides the implementation of bcd characters
//

#include "ubcd.h"

/*
	The following tables were copied from Joseph
	Newcomer's 1401 emulation, in order to provide
	consistent card, tape and print facilities.

	Jay Jaeger, 12/96
*/

/* The following table is given in the order of the 1401 BCD codes, and
	contains the equivalent ASCII codes for printout.
*/
char bcd_ascii[64] = {
			'b',	/* 0           - space */
			'1',	/* 1        1  - 1 */
			'2',	/* 2       2   - 2 */
			'3',	/* 3       21  - 3 */
			'4',	/* 4      4    - 4 */
			'5',	/* 5      4 1  - 5 */
			'6',    /* 6      42   - 6 */
			'7',	/* 7	  421  - 7 */
			'8',	/* 8     8     - 8 */
			'9',	/* 9     8  1  - 9 */
			'0',	/* 10    8 2   - 0 */
			'=',    /* 11    8 21  - number sign (#) or equal*/
			'\'',	/* 12    84    - at sign @ or quote */
			':',    /* 13    84 1  - colon */
			'>',	/* 14    842   - greater than */
			'',	/* 15    8421  - radical */
			' ',    /* 16   A      - substitute blank */
			'/',	/* 17   A   1  - slash */
			'S',	/* 18   A  2   - S */
			'T',	/* 19   A  21  - T */
			'U',	/* 20   A 4    - U */
			'V',	/* 21   A 4 1  - V */
			'W',	/* 22   A 42   - W */
			'X',	/* 23   A 421  - X */
			'Y',	/* 24   A8     - Y */
			'Z',	/* 25   A8  1  - Z */
			'\174',	/* 26   A8 2   - record mark */
			',',	/* 27   A8 21  - comma */
			'(',	/* 28   A84    - percent % or paren */
			'^',	/* 29   A84 1  - word separator */
			'\\',	/* 30   A842   - left oblique */
			'',    /* 31   A8421  - segment mark */
			'-',	/* 32  B       - hyphen */
			'J',	/* 33  B    1  - J */
			'K',	/* 34  B   2   - K */
			'L',	/* 35  B   21  - L */
			'M',	/* 36  B  4    - M */
			'N',	/* 37  B  4 1  - N */
			'O',	/* 38  B  42   - O */
			'P',	/* 39  B  421  - P */
			'Q',	/* 40  B 8     - Q */
			'R',	/* 41  B 8  1  - R */
			'!',	/* 42  B 8 2   - exclamation (-0) */
			'$',	/* 43  B 8 21  - dollar sign */
			'*',	/* 44  B 84    - asterisk */
			']',	/* 45  B 84 1  - right bracket */
			';',    /* 46  B 842   - semicolon */
			'\177', /* 47  B 8421  - delta */
			'+',    /* 48  BA      - ampersand or plus */
			'A',	/* 49  BA   1  - A */
			'B',    /* 50  BA  2   - B */
			'C',	/* 51  BA  21  - C */
			'D',	/* 52  BA 4    - D */
			'E',	/* 53  BA 4 1  - E */
			'F',	/* 54  BA 42   - F */
			'G',	/* 55  BA 421  - G */
			'H',	/* 56  BA8     - H */
			'I',	/* 57  BA8  1  - I */
			'?',	/* 58  BA8 2   - question mark */
			'.',	/* 59  BA8 21  - period */
			')',	/* 60  BA84    - lozenge or paren */
			'[',	/* 61  BA84 1  - left bracket */
			'<',	/* 62  BA842   - less than */
			''		/* 63  BA8421  - group mark */
};

char cdc_ascii[64] =  {
	'b', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
	'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
	'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
	'X', 'Y', 'Z', '0', '1', '2', '3', '4',
	'5', '6', '7', '8', '9', '+', '-', '*',
	'/', '(', ')', '$', '=', ' ', ',', '.', 
	'a', 'x', 'c', 'd', 'e', 'f', 'g', 'h', 'y' };

char bcdic_ascii[64] = {
	' ', '.', '<', '(', '+', '|', '&', '$',
	'*', ')', ';', '~', '-', '/', '\'', '%',
	'_', '>', '?', ':', '#', '@', ',', '=',
	'"', 'a', 'A', 'B', 'C', 'D', 'E', 'F',
        'G', 'H', 'I', 'b', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T',
        'U', 'V', 'W', 'X', 'Y', 'X', 'Z', '0',
	'1', '2', '3', '4', '5', '6', '7', '8', '9'};

char ctss_ascii[64] = {
        '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', // Correct
	'"', '=', '\'', 'b', '|', '&', '+',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', // Correct
        '~', '.', ')', '%', '#', '_', '-', 
	'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 
	';', '$', '*', 'a', '@', '<', ' ', '/', 	// Correct
	'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'X', 'Z',
	',', '(', '>', '?', ':', 

};

char ibsys_ascii[64] = {
/* 00 */ '0', '1', '2', '3', '4', '5', '6', '7',
/* 10 */ '8', '9', ' ', '=', '\'', ':', '>', '{',
/* 60 */ '+', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
/* 70 */ 'H', 'I', '?', '.', ')', '[', '<', '}',
/* 40 */ '-', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
/* 50 */ 'Q', 'R', '!', '$', '*', ']', ';', '_',
/* 20 */ ' ', '/', 'S', 'T', 'U', 'V', 'W', 'X',
/* 30 */ 'Y', 'Z', '|', ',', '(', '~', '\\', '"',
};
 
char bin_ascii[64] = {
			'0',	/* 10    8 2   - 0 */
			'1',	/* 1        1  - 1 */
			'2',	/* 2       2   - 2 */
			'3',	/* 3       21  - 3 */
			'4',	/* 4      4    - 4 */
			'5',	/* 5      4 1  - 5 */
			'6',    /* 6      42   - 6 */
			'7',	/* 7	  421  - 7 */
			'8',	/* 8     8     - 8 */
			'9',	/* 9     8  1  - 9 */
			' ',	/* 0           - space */
			'=',    /* 11    8 21  - number sign (#) or equal*/
			'\'',	/* 12    84    - at sign @ or quote */
			':',    /* 13    84 1  - colon */
			'>',	/* 14    842   - greater than */
			'',	/* 15    8421  - radical */
			' ',    /* 16   A      - substitute blank */
			'\177', /* 47  B 8421  - delta */
			'+',    /* 48  BA      - ampersand or plus */
			'A',	/* 49  BA   1  - A */
			'B',    /* 50  BA  2   - B */
			'C',	/* 51  BA  21  - C */
			'D',	/* 52  BA 4    - D */
			'E',	/* 53  BA 4 1  - E */
			'F',	/* 54  BA 42   - F */
			'G',	/* 55  BA 421  - G */
			'H',	/* 56  BA8     - H */
			'I',	/* 57  BA8  1  - I */
			'?',	/* 58  BA8 2   - question mark */
			'.',	/* 59  BA8 21  - period */
			')',	/* 60  BA84    - lozenge or paren */
			'[',	/* 61  BA84 1  - left bracket */
			'<',	/* 62  BA842   - less than */
			'',		/* 63  BA8421  - group mark */
			'J',	/* 33  B    1  - J */
			'K',	/* 34  B   2   - K */
			'L',	/* 35  B   21  - L */
			'M',	/* 36  B  4    - M */
			'N',	/* 37  B  4 1  - N */
			'O',	/* 38  B  42   - O */
			'P',	/* 39  B  421  - P */
			'Q',	/* 40  B 8     - Q */
			'R',	/* 41  B 8  1  - R */
			'!',	/* 42  B 8 2   - exclamation (-0) */
			'$',	/* 43  B 8 21  - dollar sign */
			'*',	/* 44  B 84    - asterisk */
			']',	/* 45  B 84 1  - right bracket */
			';',    /* 46  B 842   - semicolon */
			'/',	/* 17   A   1  - slash */
			'S',	/* 18   A  2   - S */
			'T',	/* 19   A  21  - T */
			'U',	/* 20   A 4    - U */
			'V',	/* 21   A 4 1  - V */
			'W',	/* 22   A 42   - W */
			'X',	/* 23   A 421  - X */
			'Y',	/* 24   A8     - Y */
			'Z',	/* 25   A8  1  - Z */
			'\174',	/* 26   A8 2   - record mark */
			',',	/* 27   A8 21  - comma */
			'(',	/* 28   A84    - percent % or paren */
			'^',	/* 29   A84 1  - word separator */
			'\\',	/* 30   A842   - left oblique */
			'',    /* 31   A8421  - segment mark */
			'-'	/* 32  B       - hyphen */
};


/*****************************************************************************
The following table is used to convert ASCII characters to BCD.

Note that it currently is not complete.

The following substitutions or alternate mappings are made:

		ASCII code	BCD		Notes
		----------  ---     -----
		"			N/A		illegal
		%			(		'H' character set representation
		&			+		'H' character set representation
		@			'		'H' character set representation
		#			=		'H' character set representation
		_			N/A		illegal
		^			^		substitute graphic for word-separator
		`			N/A		illegal
		a,c-z		A,C-Z	case folded
		b			b		substitute blank
		{			N/A		illegal
		}           N/A     illegal
        ~			N/A		illegal
		|					substitute for record mark

*****************************************************************************/

int ascii_bcd[256] = {
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 00 - 07 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 010 - 017 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 020 - 027 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 030 - 037 illegal */

	0,				/* 040 space */
	42,				/* 041 ! */
	-1,				/* 042 " illegal */
	11,				/* 043 # */
	43,				/* 044 $ */
	28,				/* 045 % also ( */
	48,				/* 046 & also + */
	12,				/* 047 ' also @ */

	28,				/* 050 ( also % */
	60,				/* 051 ) also lozenge */
	44,				/* 052 * */
	48,				/* 053 + also & */
	27,				/* 055 , */
	32,				/* 055 - */
	59,				/* 056 . */
	17,				/* 057 / */

	10,				/* 060 0 */
	1,				/* 061 1 */
	2,				/* 062 2 */
	3,				/* 063 3 */
	4,				/* 064 4 */
	5,				/* 065 5 */
	6,				/* 066 6 */
	7,				/* 067 7 */

	8,				/* 070 8 */
	9,				/* 071 9 */
	13,				/* 072 : */
	46,				/* 073 ; */
	62,				/* 074 < */
	11,				/* 075 = also # */
	14,				/* 076 > */
	58,				/* 077 ? */

	12,				/* 0100 @ */
	49,				/* 0101 A */
	50,				/* 0102 B */
	51,				/* 0103 C */
	52,				/* 0104 D */
	53,				/* 0105 E */
	54,				/* 0106 F */
	55,				/* 0107 G */

	56,				/* 0110 H */
	57,				/* 0111 I */
    33,				/* 0112 J */
	34,				/* 0113 K */
	35,				/* 0114 L */
	36,				/* 0115 M */
	37,				/* 0116 N */
	38,				/* 0117 O */

	39,				/* 0120 P */
	40,				/* 0121 Q */
	41,				/* 0122 R */
	18,				/* 0123 S */
	19,				/* 0124 T */
	20,				/* 0125 U */
	21,				/* 0126 V */
	22,				/* 0127 W */

	23,				/* 0130 X */
	24,				/* 0131 Y */
	25,				/* 0132 Z */
	61,				/* 0133 [ */
	30,				/* 0134 \ */
	45,				/* 0135 ] */
	29,				/* 0136 ^ word separator */
	-1,				/* 0137 _ illegal */

	-1,				/* 0140 ` illegal */
	49,				/* 0141 a is A */
	16,				/* 0142 b is substitute blank */
	51,				/* 0143 c is C */
	52,				/* 0144 d is D */
	53,				/* 0145 e is E */
	54,				/* 0146 f is F */
	55,				/* 0147 g is G */

	56,				/* 0150 h is H */
	57,				/* 0151 i is I */
	33,				/* 0152 j is J */
	34,				/* 0153 k is K */
	35,				/* 0154 l is L */
	36,				/* 0155 m is M */
	37,				/* 0156 n is N */
	38,				/* 0157 o is O */

	39,				/* 0160 p is P */
	40,				/* 0161 q is Q */
	41,				/* 0162 r is R */
	18,				/* 0163 s is S */
	19,				/* 0164 t is T */
	20,				/* 0165 u is U */
	21,				/* 0166 v is V */
	22,				/* 0167 w is W */

	23,				/* 0170 x is X */
	24,				/* 0171 y is Y */
	25,				/* 0172 z is Z */
	-1,				/* 0173 { illegal */
	26,				/* 0174 | substitute record mark */
	-1,				/* 0175	} illegal */
	-1,				/* 0176 ~ illegal */
	47,				/* 0177 delta */

	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0200-0207 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0210-0217 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0220-0227 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0230-0237 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0240-0247 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0250-0257 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0260-0267 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0270-0277 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0300-0307 illegal */

	-1,-1,-1,-1,-1,-1,			/* 0310-0315 illegal */
	63,							/* 0316 group mark   */
	-1,							/* 0317 illegal */

	-1,-1,-1,-1,-1,-1,-1,		/* 0320-0326 illegal */
	31,							/* 0327 segment mark */

	26,							/* 0330 record mark  */
	-1,-1,-1,-1,-1,-1,-1,		/* 0331-0337 illegal */

	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0340-0347 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0350-0357 illegal */
	-1,-1,-1,-1,-1,-1,-1,-1,	/* 0360-0367 illegal */
	-1,-1,-1,					/* 0370-0372 illegal */
	15,							/* 373 radical       */
	-1,-1,-1,-1};				/* 0374-0377 illegal */



